/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;

@Component
public class DefaultDistributionManager
implements DistributionManager,
Initializable {
    private static final String JOBID = "distribution";
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private JobManager jobManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    private Logger logger;
    private CoreExtension distributionExtension;
    private ExtensionId uiExtensionId;
    private DistributionJobStatus previousStatus;
    private DistributionManager.DistributionState distributionState;
    private DistributionJob distributionJob;

    public void initialize() throws InitializationException {
        this.distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        this.previousStatus = (DistributionJobStatus)this.jobManager.getJobStatus(JOBID);
        if (this.distributionExtension != null) {
            int diff;
            ExtensionId distributionExtensionId;
            ExtensionId previousExtensionId;
            this.distributionState = this.previousStatus == null ? DistributionManager.DistributionState.NEW : ((previousExtensionId = this.previousStatus.getDistributionExtension()).equals((Object)(distributionExtensionId = this.distributionExtension.getId())) ? DistributionManager.DistributionState.SAME : (!distributionExtensionId.getId().equals(previousExtensionId.getId()) ? DistributionManager.DistributionState.DIFFERENT : ((diff = distributionExtensionId.getVersion().compareTo((Object)previousExtensionId.getVersion())) > 0 ? DistributionManager.DistributionState.UPGRADE : DistributionManager.DistributionState.DOWNGRADE)));
            Model mavenModel = (Model)this.distributionExtension.getProperty("maven.Model");
            String uiId = mavenModel.getProperties().getProperty("xwiki.extension.distribution.ui");
            if (uiId != null) {
                this.uiExtensionId = new ExtensionId(uiId, this.distributionExtension.getId().getVersion());
            }
        } else {
            this.distributionState = DistributionManager.DistributionState.NONE;
        }
    }

    @Override
    public DistributionJob startJob() {
        try {
            this.distributionJob = (DistributionJob)((Object)this.componentManager.getInstance(Job.class, JOBID));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to create distribution job", (Throwable)e);
        }
        final DistributionRequest request = new DistributionRequest();
        request.setId(JOBID);
        Thread distributionJobThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ExecutionContext context = new ExecutionContext();
                try {
                    DefaultDistributionManager.this.executionContextManager.initialize(context);
                }
                catch (ExecutionContextException e) {
                    throw new RuntimeException("Failed to initialize IRC Bot's execution context", e);
                }
                DefaultDistributionManager.this.distributionJob.start((Request)request);
            }
        });
        distributionJobThread.setDaemon(true);
        distributionJobThread.setName("Distribution initialization");
        distributionJobThread.start();
        return this.distributionJob;
    }

    @Override
    public DistributionManager.DistributionState getDistributionState() {
        return this.distributionState;
    }

    @Override
    public CoreExtension getDistributionExtension() {
        return this.distributionExtension;
    }

    @Override
    public ExtensionId getUIExtensionId() {
        return this.uiExtensionId;
    }

    @Override
    public DistributionJobStatus getPreviousJobStatus() {
        return this.previousStatus;
    }

    @Override
    public DistributionJob getJob() {
        return this.distributionJob;
    }
}

