/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionStepStatus;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="DistributionInitializerListener")
public class DistributionInitializerListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ApplicationStartedEvent());
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "DistributionInitializerListener";
    }

    public void onEvent(Event arg0, Object arg1, Object arg2) {
        DistributionManager.DistributionState distributionState = this.distributionManager.getDistributionState();
        if (distributionState == DistributionManager.DistributionState.SAME) {
            DistributionJobStatus status = this.distributionManager.getPreviousJobStatus();
            for (DistributionStepStatus step : status.getSteps()) {
                if (step.getUpdateState() != null) continue;
                this.distributionManager.startJob();
                break;
            }
            if (this.distributionManager.getJob() != null) {
                this.logger.info("Distribution up to date");
            } else {
                this.logger.info("Distribution partially up to date");
            }
        } else {
            this.logger.info("Distribution state: {}", (Object)distributionState);
            this.distributionManager.startJob();
        }
    }
}

