/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.FarmDistributionJob;
import org.xwiki.extension.distribution.internal.job.FarmDistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.WikiDistributionJob;
import org.xwiki.extension.distribution.internal.job.WikiDistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.UpgradeModeDistributionStep;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;
import org.xwiki.logging.LoggerManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
public class DefaultDistributionManager
implements DistributionManager,
Initializable {
    private static final String JOBID = "distribution";
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private JobManager jobManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    protected Provider<ObservationManager> observationManagerProvider;
    @Inject
    protected Provider<LoggerManager> loggerManagerProvider;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;
    private CoreExtension distributionExtension;
    private ExtensionId mainUIExtensionId;
    private ExtensionId wikiUIExtensionId;
    private FarmDistributionJob farmDistributionJob;
    private Map<String, WikiDistributionJob> wikiDistributionJobs = new ConcurrentHashMap<String, WikiDistributionJob>();

    public void initialize() throws InitializationException {
        this.distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        if (this.distributionExtension != null) {
            String wikiUIId;
            Model mavenModel = (Model)this.distributionExtension.getProperty("maven.Model");
            String mainUIId = mavenModel.getProperties().getProperty("xwiki.extension.distribution.ui");
            if (mainUIId != null) {
                this.mainUIExtensionId = new ExtensionId(mainUIId, this.distributionExtension.getId().getVersion());
            }
            if ((wikiUIId = mavenModel.getProperties().getProperty("xwiki.extension.distribution.wikiui")) != null) {
                this.wikiUIExtensionId = new ExtensionId(wikiUIId, this.distributionExtension.getId().getVersion());
            }
        }
    }

    private List<String> getFarmJobId() {
        return Arrays.asList(JOBID);
    }

    @Override
    public FarmDistributionJob startFarmJob() {
        try {
            this.farmDistributionJob = (FarmDistributionJob)this.componentManager.getInstance(Job.class, JOBID);
            final DistributionRequest request = new DistributionRequest();
            request.setId(this.getFarmJobId());
            request.setWiki("xwiki");
            Thread distributionJobThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext context = new ExecutionContext();
                    try {
                        DefaultDistributionManager.this.executionContextManager.initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize farm distribution job execution context", e);
                    }
                    DefaultDistributionManager.this.farmDistributionJob.start((Request)request);
                }
            });
            distributionJobThread.setDaemon(true);
            distributionJobThread.setName("Farm distribution initialization");
            distributionJobThread.start();
            return this.farmDistributionJob;
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to create farm distribution job", (Throwable)e);
            return null;
        }
    }

    private List<String> getWikiJobId(String wiki) {
        return Arrays.asList(JOBID, "wiki", wiki);
    }

    @Override
    public WikiDistributionJob startWikiJob(String wiki) {
        try {
            WikiDistributionJob wikiJob = (WikiDistributionJob)this.componentManager.getInstance(Job.class, "wikidistribution");
            this.wikiDistributionJobs.put(wiki, wikiJob);
            final DistributionRequest request = new DistributionRequest();
            request.setId(this.getWikiJobId(wiki));
            request.setWiki(wiki);
            Thread distributionJobThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext context = new ExecutionContext();
                    try {
                        DefaultDistributionManager.this.executionContextManager.initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize wiki distribution job execution context", e);
                    }
                    ((WikiDistributionJob)DefaultDistributionManager.this.wikiDistributionJobs.get(request.getWiki())).start((Request)request);
                }
            });
            distributionJobThread.setDaemon(true);
            distributionJobThread.setName("Distribution initialization of wiki [" + wiki + "]");
            distributionJobThread.start();
            return wikiJob;
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to create distribution job for wiki [" + wiki + "]", (Throwable)e);
            return null;
        }
    }

    private DistributionManager.DistributionState getDistributionState(DistributionJobStatus<?> previousStatus) {
        return DistributionJobStatus.getDistributionState(previousStatus != null ? previousStatus.getDistributionExtension() : null, this.distributionExtension != null ? this.distributionExtension.getId() : null);
    }

    @Override
    public DistributionManager.DistributionState getFarmDistributionState() {
        return this.getDistributionState(this.getPreviousFarmJobStatus());
    }

    @Override
    public DistributionManager.DistributionState getWikiDistributionState(String wiki) {
        return this.getDistributionState(this.getPreviousWikiJobStatus(wiki));
    }

    @Override
    public CoreExtension getDistributionExtension() {
        return this.distributionExtension;
    }

    @Override
    public ExtensionId getMainUIExtensionId() {
        return this.mainUIExtensionId;
    }

    @Override
    public ExtensionId getWikiUIExtensionId() {
        return this.wikiUIExtensionId;
    }

    @Override
    public FarmDistributionJobStatus getPreviousFarmJobStatus() {
        DistributionJobStatus jobStatus = (DistributionJobStatus)this.jobManager.getJobStatus(this.getFarmJobId());
        FarmDistributionJobStatus farmJobStatus = jobStatus != null ? (jobStatus instanceof FarmDistributionJobStatus ? (FarmDistributionJobStatus)jobStatus : new FarmDistributionJobStatus(jobStatus, (ObservationManager)this.observationManagerProvider.get(), (LoggerManager)this.loggerManagerProvider.get())) : null;
        return farmJobStatus;
    }

    @Override
    public WikiDistributionJobStatus getPreviousWikiJobStatus(String wiki) {
        return (WikiDistributionJobStatus)this.jobManager.getJobStatus(this.getWikiJobId(wiki));
    }

    @Override
    public UpgradeModeDistributionStep.UpgradeMode getUpgradeMode() {
        FarmDistributionJobStatus status;
        if (this.farmDistributionJob != null && (status = (FarmDistributionJobStatus)this.farmDistributionJob.getStatus()) != null) {
            return status.getUpgradeMode();
        }
        return UpgradeModeDistributionStep.UpgradeMode.WIKI;
    }

    @Override
    public FarmDistributionJob getFarmJob() {
        return this.farmDistributionJob;
    }

    @Override
    public WikiDistributionJob getWikiJob(String wiki) {
        return this.wikiDistributionJobs.get(wiki);
    }

    @Override
    public DistributionJob getCurrentDistributionJob() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki() ? this.getFarmJob() : this.getWikiJob(xcontext.getDatabase());
    }

    @Override
    public boolean canDisplayDistributionWizard() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference currentUser = xcontext.getUserReference();
        if (currentUser != null) {
            return this.authorizationManager.hasAccess(Right.ADMIN, currentUser, (EntityReference)new WikiReference(xcontext.getDatabase()));
        }
        if (xcontext.isMainWiki()) {
            try {
                return RightsManager.getInstance().countAllGlobalUsersOrGroups(true, (Object[][])null, xcontext) == 0;
            }
            catch (XWikiException e) {
                this.logger.error("Failed to count global users", (Throwable)e);
            }
        }
        return false;
    }
}

