/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.UpgradeModeDistributionStep;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="distribution")
@Singleton
public class DistributionScriptService
implements ScriptService {
    public static final String EXTENSIONERROR_KEY = "scriptservice.distribution.error";
    @Inject
    private ScriptSafeProvider scriptProvider;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="xhtml/1.0")
    private BlockRenderer xhtmlRenderer;

    private <T> T safe(T unsafe) {
        return (T)this.scriptProvider.get(unsafe);
    }

    public DistributionManager.DistributionState getState() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki() ? this.distributionManager.getFarmDistributionState() : this.distributionManager.getWikiDistributionState(xcontext.getDatabase());
    }

    public CoreExtension getDistributionExtension() {
        return this.distributionManager.getDistributionExtension();
    }

    public ExtensionId getUIExtensionId() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki() ? this.distributionManager.getMainUIExtensionId() : this.distributionManager.getWikiUIExtensionId();
    }

    public DistributionJobStatus<?> getPreviousJobStatus() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki() ? this.distributionManager.getPreviousFarmJobStatus() : this.distributionManager.getPreviousWikiJobStatus(xcontext.getDatabase());
    }

    public boolean canDisplayDistributionWizard() {
        return this.distributionManager.canDisplayDistributionWizard();
    }

    public DistributionJobStatus<?> getJobStatus() {
        DistributionJob job = this.distributionManager.getCurrentDistributionJob();
        return job != null ? job.getStatus() : null;
    }

    public String renderCurrentStepToXHTML() {
        JobStatus.State jobState;
        DistributionJobStatus<?> jobStatus;
        DistributionJob job = this.distributionManager.getCurrentDistributionJob();
        if (job != null && (jobStatus = job.getStatus()) != null && ((jobState = jobStatus.getState()) == JobStatus.State.RUNNING || jobState == JobStatus.State.WAITING)) {
            Block block = job.getCurrentStep().render();
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render(block, (WikiPrinter)printer);
            return printer.toString();
        }
        return null;
    }

    public UpgradeModeDistributionStep.UpgradeMode getUpgradeMode() {
        return this.distributionManager.getUpgradeMode();
    }
}

