/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionQuestion;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.distribution.internal.job.step.UpgradeModeDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.WelcomeDistributionStep;
import org.xwiki.job.internal.AbstractJob;

public abstract class AbstractDistributionJob<R extends DistributionRequest, S extends DistributionJobStatus<R>>
extends AbstractJob<R, S>
implements DistributionJob {
    @Inject
    protected DistributionManager distributionManager;

    public String getType() {
        return "distribution";
    }

    protected abstract S createNewDistributionStatus(R var1, List<DistributionStep> var2);

    protected abstract List<DistributionStep> createSteps();

    protected S createNewStatus(R request) {
        List<DistributionStep> steps = this.createSteps();
        try {
            DistributionStep welcomeStep = (DistributionStep)this.componentManager.getInstance(DistributionStep.class, "welcome");
            welcomeStep.setState(DistributionStep.State.COMPLETED);
            steps.add(0, welcomeStep);
        }
        catch (ComponentLookupException e1) {
            this.logger.error("Failed to get step instance for id [{}]", (Object)"welcome");
        }
        S status = this.createNewDistributionStatus(request, steps);
        if (this.distributionManager.getDistributionExtension() != null) {
            DistributionJobStatus previousStatus = this.getPreviousStatus();
            if (previousStatus != null && previousStatus.getDistributionExtension() != null && !ObjectUtils.equals((Object)previousStatus.getDistributionExtension(), (Object)this.distributionManager.getDistributionExtension())) {
                ((DistributionJobStatus)((Object)status)).setDistributionExtension(previousStatus.getDistributionExtension());
                ((DistributionJobStatus)((Object)status)).setDistributionExtensionUI(previousStatus.getDistributionExtensionUI());
            }
            ((DistributionJobStatus)((Object)status)).setDistributionExtension(this.distributionManager.getDistributionExtension().getId());
            ((DistributionJobStatus)((Object)status)).setDistributionExtensionUI(this.getUIExtensionId());
        }
        return status;
    }

    protected S getDistributionJobStatus() {
        return (S)((Object)((DistributionJobStatus)this.getStatus()));
    }

    protected DistributionStep getStep(List<DistributionStep> steps, String stepId) {
        for (DistributionStep step : steps) {
            if (!step.getId().equals(stepId)) continue;
            return step;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        List<DistributionStep> steps = ((DistributionJobStatus)((Object)this.getDistributionJobStatus())).getSteps();
        this.notifyPushLevelProgress(steps.size());
        WelcomeDistributionStep welcomeStep = (WelcomeDistributionStep)this.getStep(steps, "welcome");
        UpgradeModeDistributionStep upgrademodeStep = (UpgradeModeDistributionStep)this.getStep(steps, "upgrademode");
        for (DistributionStep step : steps) {
            step.initialize(this);
            if (step.getState() != null) continue;
            if (welcomeStep != null) {
                welcomeStep.setState(null);
            }
            if (upgrademodeStep == null || upgrademodeStep.getState() != DistributionStep.State.CANCELED) continue;
            upgrademodeStep.setState(null);
        }
        try {
            for (int index = 0; index < steps.size(); ++index) {
                DistributionStep step;
                ((DistributionJobStatus)((Object)this.getDistributionJobStatus())).setCurrentStateIndex(index);
                step = steps.get(index);
                step.prepare();
                if (step.getState() == null) {
                    DistributionQuestion question = new DistributionQuestion(step);
                    ((DistributionJobStatus)this.getStatus()).ask(question);
                    if (question.getAction() != null) {
                        switch (question.getAction()) {
                            case CANCEL: {
                                while (index < steps.size()) {
                                    steps.get(index).setState(DistributionStep.State.CANCELED);
                                    ++index;
                                }
                            }
                            case SKIP: {
                                index = steps.size() - 1;
                                break;
                            }
                        }
                    }
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    @Override
    public DistributionStep getCurrentStep() {
        return ((DistributionJobStatus)this.getStatus()).getCurrentStep();
    }
}

