/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.Collections;
import java.util.List;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.observation.ObservationManager;

public class DistributionJobStatus<R extends DistributionRequest>
extends DefaultJobStatus<DistributionRequest> {
    private static final long serialVersionUID = 2L;
    private ExtensionId previousDistributionExtension;
    private ExtensionId previousDistributionExtensionUi;
    private ExtensionId distributionExtension;
    private ExtensionId distributionExtensionUi;
    private List<DistributionStep> stepList;
    private int currentStateIndex;

    public DistributionJobStatus(DistributionJobStatus<R> status, ObservationManager observationManager, LoggerManager loggerManager) {
        super(status.getRequest(), observationManager, loggerManager, false);
        this.previousDistributionExtension = status.previousDistributionExtension;
        this.previousDistributionExtensionUi = status.previousDistributionExtensionUi;
        this.distributionExtension = status.distributionExtension;
        this.distributionExtensionUi = status.distributionExtensionUi;
        this.stepList = status.stepList;
    }

    public DistributionJobStatus(R request, ObservationManager observationManager, LoggerManager loggerManager, List<DistributionStep> steps) {
        super(request, observationManager, loggerManager, false);
        this.stepList = steps;
    }

    public List<DistributionStep> getSteps() {
        return this.stepList != null ? this.stepList : Collections.emptyList();
    }

    public DistributionStep getStep(String stepId) {
        for (DistributionStep step : this.getSteps()) {
            if (!step.getId().equals(stepId)) continue;
            return step;
        }
        return null;
    }

    public int getCurrentStateIndex() {
        return this.currentStateIndex;
    }

    public DistributionStep getCurrentStep() {
        return this.getCurrentStateIndex() < this.getSteps().size() ? this.getSteps().get(this.getCurrentStateIndex()) : null;
    }

    public void setCurrentStateIndex(int currentStateIndex) {
        this.currentStateIndex = currentStateIndex;
    }

    public ExtensionId getPreviousDistributionExtension() {
        return this.previousDistributionExtension;
    }

    public void setPreviousDistributionExtension(ExtensionId previousDistributionExtension) {
        this.previousDistributionExtension = previousDistributionExtension;
    }

    public ExtensionId getPreviousDistributionExtensionUI() {
        return this.previousDistributionExtensionUi;
    }

    public void setPreviousDistributionExtensionUI(ExtensionId previousDistributionExtensionUI) {
        this.previousDistributionExtensionUi = previousDistributionExtensionUI;
    }

    public ExtensionId getDistributionExtension() {
        return this.distributionExtension;
    }

    public void setDistributionExtension(ExtensionId distributionExtension) {
        this.distributionExtension = distributionExtension;
    }

    public ExtensionId getDistributionExtensionUI() {
        return this.distributionExtensionUi;
    }

    public void setDistributionExtensionUI(ExtensionId distributionExtensionUI) {
        this.distributionExtensionUi = distributionExtensionUI;
    }

    public static DistributionManager.DistributionState getDistributionState(ExtensionId previousExtensionId, ExtensionId distributionExtensionId) {
        int diff;
        DistributionManager.DistributionState distributionState = distributionExtensionId != null ? (previousExtensionId == null ? DistributionManager.DistributionState.NEW : (previousExtensionId.equals((Object)distributionExtensionId) ? DistributionManager.DistributionState.SAME : (!distributionExtensionId.getId().equals(previousExtensionId.getId()) ? DistributionManager.DistributionState.DIFFERENT : ((diff = distributionExtensionId.getVersion().compareTo((Object)previousExtensionId.getVersion())) > 0 ? DistributionManager.DistributionState.UPGRADE : DistributionManager.DistributionState.DOWNGRADE)))) : DistributionManager.DistributionState.NONE;
        return distributionState;
    }

    public DistributionManager.DistributionState getDistributionState() {
        return DistributionJobStatus.getDistributionState(this.getPreviousDistributionExtension(), this.getDistributionExtension());
    }
}

