/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.Environment;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;

public abstract class AbstractDistributionStep
implements DistributionStep {
    private static final Pattern FIRSTLINE = Pattern.compile("^.#syntax=(.*)$", 8);
    @Inject
    protected transient ComponentManager componentManager;
    @Inject
    protected transient TransformationManager transformationManager;
    @Inject
    protected transient Environment environment;
    @Inject
    protected transient SyntaxFactory syntaxFactory;
    @Inject
    protected transient DistributionManager distributionManager;
    protected transient DistributionJob distributionJob;
    private String stepId;
    private DistributionStep.State state;

    public AbstractDistributionStep(String stepId) {
        this.stepId = stepId;
    }

    @Override
    public void initialize(DistributionJob distributionJob) {
        DistributionStep previousStep;
        this.distributionJob = distributionJob;
        DistributionJobStatus<?> previousStatus = this.distributionJob.getPreviousStatus();
        if (previousStatus != null && previousStatus.getDistributionExtension().equals((Object)this.distributionJob.getStatus().getDistributionExtension()) && (previousStep = previousStatus.getStep(this.getId())) != null) {
            this.setState(previousStep.getState());
        }
        this.prepare();
    }

    @Override
    public String getId() {
        return this.stepId;
    }

    @Override
    public DistributionStep.State getState() {
        return this.state;
    }

    @Override
    public void setState(DistributionStep.State stepState) {
        this.state = stepState;
    }

    protected String getWiki() {
        return this.distributionJob.getRequest().getWiki();
    }

    protected String getNamespace() {
        String wiki = this.getWiki();
        return wiki == null ? null : "wiki:" + this.getWiki();
    }

    protected String getTemplate() {
        return "/templates/distribution/" + this.getId() + ".wiki";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringContent getStringContent() throws IOException, ParseException {
        String content;
        InputStream stream = this.environment.getResourceAsStream(this.getTemplate());
        try {
            content = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        Matcher matcher = FIRSTLINE.matcher(content);
        if (!matcher.find()) {
            throw new ParseException("Distribution step template [" + this.getTemplate() + "] does not provide its syntax");
        }
        String syntaxString = matcher.group(1);
        Syntax syntax = this.syntaxFactory.createSyntaxFromIdString(syntaxString);
        content = content.substring(matcher.end());
        return new StringContent(content, syntax);
    }

    protected XDOM getXDOM() {
        XDOM xdom;
        try {
            StringContent content = this.getStringContent();
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, content.syntax.toIdString());
            xdom = parser.parse((Reader)new StringReader(content.content));
        }
        catch (Throwable e) {
            xdom = this.generateError(e);
        }
        return xdom;
    }

    protected XDOM generateError(Throwable throwable) {
        ArrayList<GroupBlock> errorBlocks = new ArrayList<GroupBlock>();
        Map<String, String> errorBlockParams = Collections.singletonMap("class", "xwikirenderingerror");
        errorBlocks.add(new GroupBlock(Arrays.asList(new WordBlock("Failed to render step content")), errorBlockParams));
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        VerbatimBlock descriptionBlock = new VerbatimBlock(writer.toString(), false);
        Map<String, String> errorDescriptionBlockParams = Collections.singletonMap("class", "xwikirenderingerrordescription hidden");
        errorBlocks.add(new GroupBlock(Arrays.asList(descriptionBlock), errorDescriptionBlockParams));
        return new XDOM(errorBlocks);
    }

    @Override
    public Block render() {
        XDOM content = this.getXDOM();
        TransformationContext txContext = new TransformationContext(content, null, false);
        try {
            this.transformationManager.performTransformations((Block)content, txContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    protected class StringContent {
        public String content;
        public Syntax syntax;

        public StringContent(String content, Syntax syntax) {
            this.content = content;
            this.syntax = syntax;
        }
    }
}

