/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.distribution.internal.job.step.AbstractDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.distribution.internal.job.step.UpgradeModeDistributionStep;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Named(value="extension.outdatedextensions")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class OutdatedExtensionsDistributionStep
extends AbstractDistributionStep {
    public static final String ID = "extension.outdatedextensions";
    @Inject
    private transient InstalledExtensionRepository installedRepository;

    public OutdatedExtensionsDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        if (this.getState() != DistributionStep.State.CANCELED) {
            this.setState(DistributionStep.State.COMPLETED);
            UpgradeModeDistributionStep.UpgradeMode upgradeMode = this.distributionManager.getUpgradeMode();
            Collection installedExtensions = upgradeMode == UpgradeModeDistributionStep.UpgradeMode.ALLINONE ? this.installedRepository.getInstalledExtensions() : this.installedRepository.getInstalledExtensions(this.getNamespace());
            block0: for (InstalledExtension extension : installedExtensions) {
                Collection installedNamespaces = extension.getNamespaces();
                if (installedNamespaces == null) {
                    if (extension.isValid(null)) continue;
                    this.setState(null);
                    break;
                }
                for (String installedNamespace : installedNamespaces) {
                    if (extension.isValid(installedNamespace)) continue;
                    this.setState(null);
                    continue block0;
                }
            }
        }
    }
}

