/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.FarmDistributionJob;
import org.xwiki.extension.distribution.internal.job.FarmDistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.WikiDistributionJob;
import org.xwiki.extension.distribution.internal.job.WikiDistributionJobStatus;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.job.Job;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.JobStatusStorage;
import org.xwiki.logging.LoggerManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
public class DefaultDistributionManager
implements DistributionManager,
Initializable {
    private static final String JOBID = "distribution";
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private JobManager jobManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    protected Provider<ObservationManager> observationManagerProvider;
    @Inject
    protected Provider<LoggerManager> loggerManagerProvider;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private JobStatusStorage jobStatusStorage;
    @Inject
    private Logger logger;
    private CoreExtension distributionExtension;
    private ExtensionId mainUIExtensionId;
    private ExtensionId wikiUIExtensionId;
    private FarmDistributionJob farmDistributionJob;
    private Map<String, WikiDistributionJob> wikiDistributionJobs = new ConcurrentHashMap<String, WikiDistributionJob>();

    public void initialize() throws InitializationException {
        this.distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        if (this.distributionExtension != null) {
            String wikiUIId;
            Model mavenModel = (Model)this.distributionExtension.getProperty("maven.Model");
            String mainUIId = mavenModel.getProperties().getProperty("xwiki.extension.distribution.ui");
            if (mainUIId != null) {
                String mainUIVersion = mavenModel.getProperties().getProperty("xwiki.extension.distribution.ui.version");
                this.mainUIExtensionId = new ExtensionId(mainUIId, (Version)(mainUIVersion != null ? new DefaultVersion(mainUIVersion) : this.distributionExtension.getId().getVersion()));
            }
            if ((wikiUIId = mavenModel.getProperties().getProperty("xwiki.extension.distribution.wikiui")) != null) {
                String wikiUIVersion = mavenModel.getProperties().getProperty("xwiki.extension.distribution.wikiui.version");
                this.wikiUIExtensionId = new ExtensionId(wikiUIId, (Version)(wikiUIVersion != null ? new DefaultVersion(wikiUIVersion) : this.distributionExtension.getId().getVersion()));
            }
        }
    }

    private List<String> getFarmJobId() {
        return Arrays.asList(JOBID);
    }

    @Override
    public FarmDistributionJob startFarmJob() {
        try {
            this.farmDistributionJob = (FarmDistributionJob)this.componentManager.getInstance(Job.class, JOBID);
            final DistributionRequest request = new DistributionRequest();
            request.setId(this.getFarmJobId());
            request.setWiki(((XWikiContext)this.xcontextProvider.get()).getMainXWiki());
            Thread distributionJobThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext context = new ExecutionContext();
                    try {
                        DefaultDistributionManager.this.executionContextManager.initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize farm distribution job execution context", e);
                    }
                    DefaultDistributionManager.this.farmDistributionJob.initialize((Request)request);
                    DefaultDistributionManager.this.farmDistributionJob.run();
                }
            });
            distributionJobThread.setDaemon(true);
            distributionJobThread.setName("Farm distribution initialization");
            distributionJobThread.start();
            this.farmDistributionJob.awaitReady();
            return this.farmDistributionJob;
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to create farm distribution job", (Throwable)e);
            return null;
        }
    }

    private List<String> getWikiJobId(String wiki) {
        return Arrays.asList(JOBID, "wiki", wiki);
    }

    @Override
    public WikiDistributionJob startWikiJob(String wiki) {
        try {
            WikiDistributionJob wikiJob = (WikiDistributionJob)this.componentManager.getInstance(Job.class, "wikidistribution");
            this.wikiDistributionJobs.put(wiki, wikiJob);
            final DistributionRequest request = new DistributionRequest();
            request.setId(this.getWikiJobId(wiki));
            request.setWiki(wiki);
            Thread distributionJobThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext context = new ExecutionContext();
                    try {
                        DefaultDistributionManager.this.executionContextManager.initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize wiki distribution job execution context", e);
                    }
                    WikiDistributionJob job = (WikiDistributionJob)DefaultDistributionManager.this.wikiDistributionJobs.get(request.getWiki());
                    job.initialize((Request)request);
                    job.run();
                }
            });
            distributionJobThread.setDaemon(true);
            distributionJobThread.setName("Distribution initialization of wiki [" + wiki + "]");
            distributionJobThread.start();
            wikiJob.awaitReady();
            return wikiJob;
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to create distribution job for wiki [" + wiki + "]", (Throwable)e);
            return null;
        }
    }

    private DistributionManager.DistributionState getDistributionState(DistributionJobStatus<?> previousStatus) {
        return DistributionJobStatus.getDistributionState(previousStatus != null ? previousStatus.getDistributionExtension() : null, this.distributionExtension != null ? this.distributionExtension.getId() : null);
    }

    @Override
    public DistributionManager.DistributionState getFarmDistributionState() {
        FarmDistributionJobStatus previousStatus = null;
        try {
            previousStatus = this.getPreviousFarmJobStatus();
        }
        catch (Exception e) {
            this.logger.error("Failed to load previous status", (Throwable)e);
        }
        return this.getDistributionState(previousStatus);
    }

    @Override
    public DistributionManager.DistributionState getWikiDistributionState(String wiki) {
        return this.getDistributionState(this.getPreviousWikiJobStatus(wiki));
    }

    @Override
    public CoreExtension getDistributionExtension() {
        return this.distributionExtension;
    }

    @Override
    public ExtensionId getMainUIExtensionId() {
        return this.mainUIExtensionId;
    }

    @Override
    public ExtensionId getWikiUIExtensionId() {
        return this.wikiUIExtensionId;
    }

    @Override
    public FarmDistributionJobStatus getPreviousFarmJobStatus() {
        DistributionJobStatus jobStatus = (DistributionJobStatus)this.jobManager.getJobStatus(this.getFarmJobId());
        FarmDistributionJobStatus farmJobStatus = jobStatus != null ? (jobStatus instanceof FarmDistributionJobStatus ? (FarmDistributionJobStatus)jobStatus : new FarmDistributionJobStatus(jobStatus, (ObservationManager)this.observationManagerProvider.get(), (LoggerManager)this.loggerManagerProvider.get())) : null;
        return farmJobStatus;
    }

    @Override
    public WikiDistributionJobStatus getPreviousWikiJobStatus(String wiki) {
        return (WikiDistributionJobStatus)this.jobManager.getJobStatus(this.getWikiJobId(wiki));
    }

    @Override
    public FarmDistributionJob getFarmJob() {
        return this.farmDistributionJob;
    }

    @Override
    public WikiDistributionJob getWikiJob(String wiki) {
        return this.wikiDistributionJobs.get(wiki);
    }

    @Override
    public DistributionJob getCurrentDistributionJob() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki() ? this.getFarmJob() : this.getWikiJob(xcontext.getDatabase());
    }

    @Override
    public boolean canDisplayDistributionWizard() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference currentUser = xcontext.getUserReference();
        if (currentUser != null) {
            return this.authorizationManager.hasAccess(Right.ADMIN, currentUser, (EntityReference)new WikiReference(xcontext.getDatabase()));
        }
        if (xcontext.isMainWiki()) {
            try {
                return RightsManager.getInstance().countAllGlobalUsersOrGroups(true, (Object[][])null, xcontext) == 0;
            }
            catch (XWikiException e) {
                this.logger.error("Failed to count global users", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void deletePreviousWikiJobStatus(String wiki) {
        this.jobStatusStorage.remove(this.getWikiJobId(wiki));
        this.wikiDistributionJobs.remove(wiki);
    }

    @Override
    public void copyPreviousWikiJobStatus(String sourceWiki, String targetWiki) {
        WikiDistributionJobStatus sourceStatus = this.getPreviousWikiJobStatus(sourceWiki);
        if (sourceStatus != null) {
            WikiDistributionJobStatus targetStatus = new WikiDistributionJobStatus(sourceStatus, (ObservationManager)this.observationManagerProvider.get(), (LoggerManager)this.loggerManagerProvider.get());
            DistributionRequest request = (DistributionRequest)targetStatus.getRequest();
            request.setId(this.getWikiJobId(targetWiki));
            request.setWiki(targetWiki);
            this.jobStatusStorage.store((JobStatus)targetStatus);
        }
    }
}

