/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.List;
import java.util.concurrent.locks.Condition;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionQuestion;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.distribution.internal.job.step.ReportDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.WelcomeDistributionStep;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.AbstractJob;

public abstract class AbstractDistributionJob<R extends DistributionRequest, S extends DistributionJobStatus<R>>
extends AbstractJob<R, S>
implements DistributionJob {
    @Inject
    protected DistributionManager distributionManager;
    protected final Condition readyCondition;

    public AbstractDistributionJob() {
        this.readyCondition = this.lock.newCondition();
    }

    public String getType() {
        return "distribution";
    }

    protected abstract S createNewDistributionStatus(R var1, List<DistributionStep> var2);

    protected abstract List<DistributionStep> createSteps();

    protected S createNewStatus(R request) {
        DistributionStep welcomeStep;
        List<DistributionStep> steps = this.createSteps();
        try {
            welcomeStep = (DistributionStep)this.componentManager.getInstance(DistributionStep.class, "welcome");
            welcomeStep.setState(DistributionStep.State.COMPLETED);
            steps.add(0, welcomeStep);
        }
        catch (ComponentLookupException e1) {
            this.logger.error("Failed to get step instance for id [{}]", (Object)"welcome");
        }
        try {
            welcomeStep = (DistributionStep)this.componentManager.getInstance(DistributionStep.class, "report");
            welcomeStep.setState(DistributionStep.State.COMPLETED);
            steps.add(welcomeStep);
        }
        catch (ComponentLookupException e1) {
            this.logger.error("Failed to get step instance for id [{}]", (Object)"report");
        }
        S status = this.createNewDistributionStatus(request, steps);
        if (this.distributionManager.getDistributionExtension() != null) {
            DistributionJobStatus previousStatus = this.getPreviousStatus();
            if (previousStatus != null && previousStatus.getDistributionExtension() != null && !ObjectUtils.equals((Object)previousStatus.getDistributionExtension(), (Object)this.distributionManager.getDistributionExtension())) {
                ((DistributionJobStatus)((Object)status)).setPreviousDistributionExtension(previousStatus.getDistributionExtension());
                ((DistributionJobStatus)((Object)status)).setPreviousDistributionExtensionUI(previousStatus.getDistributionExtensionUI());
            }
            ((DistributionJobStatus)((Object)status)).setDistributionExtension(this.distributionManager.getDistributionExtension().getId());
            ((DistributionJobStatus)((Object)status)).setDistributionExtensionUI(this.getUIExtensionId());
        }
        return status;
    }

    protected S getDistributionJobStatus() {
        return (S)((Object)((DistributionJobStatus)this.getStatus()));
    }

    protected DistributionStep getStep(List<DistributionStep> steps, String stepId) {
        for (DistributionStep step : steps) {
            if (!step.getId().equals(stepId)) continue;
            return step;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        List<DistributionStep> steps = ((DistributionJobStatus)((Object)this.getDistributionJobStatus())).getSteps();
        this.notifyPushLevelProgress(steps.size());
        WelcomeDistributionStep welcomeStep = (WelcomeDistributionStep)this.getStep(steps, "welcome");
        ReportDistributionStep reportStep = (ReportDistributionStep)this.getStep(steps, "report");
        for (DistributionStep step : steps) {
            step.initialize(this);
            if (step.getState() != null) continue;
            if (welcomeStep != null) {
                welcomeStep.setState(null);
            }
            if (reportStep == null) continue;
            reportStep.setState(null);
        }
        try {
            for (int index = 0; index < steps.size(); ++index) {
                DistributionStep step;
                ((DistributionJobStatus)((Object)this.getDistributionJobStatus())).setCurrentStateIndex(index);
                step = steps.get(index);
                step.prepare();
                if (step.getState() == null) {
                    DistributionQuestion question = new DistributionQuestion(step);
                    this.signalReady();
                    ((DistributionJobStatus)this.getStatus()).ask(question);
                    if (question.getAction() != null) {
                        switch (question.getAction()) {
                            case CANCEL: {
                                while (index < steps.size()) {
                                    steps.get(index).setState(DistributionStep.State.CANCELED);
                                    ++index;
                                }
                            }
                            case SKIP: {
                                index = steps.size() - 1;
                                break;
                            }
                        }
                    }
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    @Override
    public DistributionStep getCurrentStep() {
        return ((DistributionJobStatus)this.getStatus()).getCurrentStep();
    }

    protected void jobFinished(Throwable exception) {
        super.jobFinished(exception);
        this.signalReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalReady() {
        this.lock.lock();
        try {
            this.readyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReady() {
        if (this.getStatus() == null || ((DistributionJobStatus)this.getStatus()).getState() == JobStatus.State.RUNNING) {
            try {
                this.lock.lockInterruptibly();
                try {
                    this.readyCondition.await();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("The distribution job has been interrupted");
            }
        }
    }
}

