/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.distribution.internal.job.step.AbstractDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="extension.defaultui.wikis")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikisDefaultUIDistributionStep
extends AbstractDistributionStep {
    public static final String ID = "extension.defaultui.wikis";
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient Logger logger;

    public WikisDefaultUIDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        if (this.getState() == null) {
            this.setState(DistributionStep.State.COMPLETED);
            if (this.isMainWiki()) {
                Collection wikis;
                WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
                try {
                    wikis = wikiDescriptorManager.getAll();
                }
                catch (WikiManagerException e) {
                    this.logger.error("Failed to get the list of wikis", (Throwable)e);
                    this.setState(null);
                    return;
                }
                ExtensionId wikiExtensionUI = this.distributionManager.getWikiUIExtensionId();
                for (WikiDescriptor wiki : wikis) {
                    InstalledExtension installedExtension;
                    if (wikiDescriptorManager.getMainWikiId().equals(wiki.getId())) continue;
                    String namespace = "wiki:" + wiki.getId();
                    if (wikiExtensionUI == null || (installedExtension = this.installedRepository.getInstalledExtension(wikiExtensionUI.getId(), namespace)) != null && installedExtension.getId().getVersion().equals(wikiExtensionUI.getVersion())) continue;
                    this.setState(null);
                    return;
                }
            }
        }
    }
}

