/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.distribution.internal.job.step.AbstractDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Named(value="extension.outdatedextensions")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class OutdatedExtensionsDistributionStep
extends AbstractDistributionStep {
    public static final String ID = "extension.outdatedextensions";
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient Logger logger;

    public OutdatedExtensionsDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        block6: {
            if (this.getState() != null) break block6;
            this.setState(DistributionStep.State.COMPLETED);
            if (this.isMainWiki()) {
                Collection installedExtensions = this.installedRepository.getInstalledExtensions();
                block0: for (InstalledExtension extension : installedExtensions) {
                    Collection installedNamespaces = extension.getNamespaces();
                    if (installedNamespaces == null) {
                        if (extension.isValid(null)) continue;
                        this.logger.debug("Enabling outdate extension step on main wiki because extension [{}] is invalid on root namespace", (Object)extension.getId());
                        this.setState(null);
                        break;
                    }
                    for (String installedNamespace : installedNamespaces) {
                        if (extension.isValid(installedNamespace)) continue;
                        this.logger.debug("Enabling outdate extension step on main wiki because extension [{}] is invalid on namespace [{}]", (Object)extension.getId(), (Object)installedNamespace);
                        this.setState(null);
                        continue block0;
                    }
                }
            } else {
                String currentNamespace = this.getNamespace();
                Collection installedExtensions = this.installedRepository.getInstalledExtensions(currentNamespace);
                for (InstalledExtension extension : installedExtensions) {
                    if (extension.isValid(currentNamespace)) continue;
                    this.logger.debug("Enabling outdate extension step on wiki [{}]because extension [{}] is invalid", (Object)this.getWiki(), (Object)extension.getId());
                    this.setState(null);
                    break;
                }
            }
        }
    }
}

