/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar;

import java.util.EnumMap;
import java.util.Map;
import org.xwiki.extension.xar.question.ConflictQuestion;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.stability.Unstable;
import org.xwiki.xar.XarEntryType;

@Unstable
public class XWikiDocumentMergerConfiguration {
    private final Map<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction> conflictActions = new EnumMap<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction>(ConflictQuestion.ConflictType.class);
    private DocumentReference authorReference;
    private XarEntryType.UpgradeType type;

    public XWikiDocumentMergerConfiguration() {
        this.setConflictAction(ConflictQuestion.ConflictType.CURRENT_DELETED, ConflictQuestion.GlobalAction.CURRENT);
        this.setConflictAction(ConflictQuestion.ConflictType.MERGE_SUCCESS, ConflictQuestion.GlobalAction.MERGED);
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public void setAuthorReference(DocumentReference author) {
        this.authorReference = author;
    }

    public ConflictQuestion.GlobalAction getConflictAction(ConflictQuestion.ConflictType type) {
        return this.conflictActions.get((Object)type);
    }

    public void setConflictAction(ConflictQuestion.ConflictType type, ConflictQuestion.GlobalAction action) {
        this.setConflictAction(type, action, action);
    }

    public void setConflictAction(ConflictQuestion.ConflictType type, ConflictQuestion.GlobalAction action, ConflictQuestion.GlobalAction defaultAnswer) {
        this.conflictActions.put(type, action != null ? action : defaultAnswer);
    }

    public Map<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction> getConflictActions() {
        return this.conflictActions;
    }

    public void setConflictActions(Map<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction> conflictActions) {
        this.conflictActions.clear();
        this.conflictActions.putAll(conflictActions);
    }

    public XarEntryType.UpgradeType getType() {
        return this.type;
    }

    public void setType(XarEntryType.UpgradeType type) {
        this.type = type;
    }
}

