/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.internal.event.MandatoryDocumentsInitializedEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.doc.InstalledExtensionDocumentTree;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="InstalledExtensionDocumentTree.MandatoryDocumentInitializerListener")
@Singleton
public class MandatoryDocumentInitializerListener
extends AbstractEventListener {
    public static final String HINT = "InstalledExtensionDocumentTree.MandatoryDocumentInitializerListener";
    @Inject
    private Logger logger;
    @Inject
    private InstalledExtensionDocumentTree tree;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeStringEntityReferenceResolver;
    @Inject
    private DocumentReferenceResolver<EntityReference> defaultReferenceDocumentReferenceResolver;
    @Inject
    private Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> readOnlyXWikiContextProvider;

    public MandatoryDocumentInitializerListener() {
        super(HINT, new Event[]{new MandatoryDocumentsInitializedEvent(), new ComponentDescriptorAddedEvent(MandatoryDocumentInitializer.class), new ComponentDescriptorRemovedEvent(MandatoryDocumentInitializer.class)});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof MandatoryDocumentsInitializedEvent) {
            this.getMandatoryDocuments(((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getCurrentWikiId()).stream().forEach(this.tree::addExtensionPage);
        } else if (event instanceof ComponentDescriptorAddedEvent) {
            this.getMandatoryDocuments(event).stream().forEach(this.tree::addExtensionPage);
        } else if (event instanceof ComponentDescriptorRemovedEvent) {
            this.getMandatoryDocuments(event).stream().forEach(this.tree::removeExtensionPage);
        }
    }

    private Set<DocumentReference> getMandatoryDocuments(String wiki) {
        try {
            List mandatoryDocumentInitializers = ((ComponentManager)this.contextComponentManagerProvider.get()).getInstanceList(MandatoryDocumentInitializer.class);
            WikiReference wikiReference = new WikiReference(wiki);
            HashSet<DocumentReference> mandatoryDocuments = new HashSet<DocumentReference>();
            for (MandatoryDocumentInitializer mandatoryDocumentInitializer : mandatoryDocumentInitializers) {
                DocumentReference documentReference = this.defaultReferenceDocumentReferenceResolver.resolve((Object)mandatoryDocumentInitializer.getDocumentReference(), new Object[]{wikiReference});
                if (!documentReference.getWikiReference().equals((Object)wikiReference)) continue;
                mandatoryDocuments.add(documentReference);
            }
            return mandatoryDocuments;
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve the list of mandatory documents for wiki [{}].", (Object)wiki, (Object)e);
            return Collections.emptySet();
        }
    }

    private Set<DocumentReference> getMandatoryDocuments(Event event) {
        EntityReference relativeDocumentReference = this.relativeStringEntityReferenceResolver.resolve((Object)((ComponentDescriptorEvent)event).getRoleHint(), EntityType.DOCUMENT, new Object[0]);
        EntityReference wikiReference = relativeDocumentReference.extractReference(EntityType.WIKI);
        if (wikiReference != null) {
            return Collections.singleton(new DocumentReference(relativeDocumentReference));
        }
        if (this.readOnlyXWikiContextProvider.get() != null) {
            try {
                return ((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getAllIds().stream().map(wikiId -> this.defaultReferenceDocumentReferenceResolver.resolve((Object)relativeDocumentReference, new Object[]{new WikiReference(wikiId)})).collect(Collectors.toSet());
            }
            catch (WikiManagerException e) {
                this.logger.error("Failed to get the list of wikis.", (Throwable)e);
            }
        }
        return Collections.emptySet();
    }
}

