/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiCopiedEvent;
import org.xwiki.bridge.event.WikiCreatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionInstallingEvent;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.Request;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="extension.xar.WikiCopiedListener")
public class WikiEventListener
extends AbstractEventListener {
    private static final String PROPERTY_USER_REFERENCE = "user.reference";
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    @Named(value="xar")
    private Provider<ExtensionHandler> xarHandlerProvider;
    @Inject
    private ObservationManager observation;
    @Inject
    private Logger logger;

    public WikiEventListener() {
        super("extension.xar.WikiCopiedListener", new Event[]{new WikiCopiedEvent(), new WikiCreatedEvent(), new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object o, Object context) {
        if (event instanceof WikiCopiedEvent) {
            this.onWikiCopied((WikiCopiedEvent)event);
        } else if (event instanceof WikiCreatedEvent) {
            this.onWikiCreated((WikiCreatedEvent)event, (XWikiContext)context);
        } else if (event instanceof WikiDeletedEvent) {
            this.onWikiDeleted((WikiDeletedEvent)event);
        }
    }

    private void onWikiCopied(WikiCopiedEvent event) {
        String sourceNamespace = new WikiNamespace(event.getSourceWikiId()).serialize();
        String targetNamespace = new WikiNamespace(event.getTargetWikiId()).serialize();
        Collection installedExtensions = this.installedRepository.getInstalledExtensions(sourceNamespace);
        for (InstalledExtension installedExtension : installedExtensions) {
            this.copyInstalledExtension(installedExtension, sourceNamespace, targetNamespace);
        }
    }

    private void copyInstalledExtension(InstalledExtension installedExtension, String sourceNamespace, String targetNamespace) {
        if (!installedExtension.isInstalled(targetNamespace) && !installedExtension.isInstalled(null)) {
            for (ExtensionDependency dependency : installedExtension.getDependencies()) {
                InstalledExtension installedDependency = this.installedRepository.getInstalledExtension(dependency.getId(), sourceNamespace);
                if (installedDependency == null) continue;
                this.copyInstalledExtension(installedDependency, sourceNamespace, targetNamespace);
            }
            try {
                this.observation.notify((Event)new ExtensionInstallingEvent(installedExtension.getId(), targetNamespace), (Object)installedExtension);
                this.extensionHandlerManager.initialize((LocalExtension)installedExtension, targetNamespace);
                this.installedRepository.installExtension((LocalExtension)installedExtension, targetNamespace, installedExtension.isDependency(sourceNamespace));
                this.observation.notify((Event)new ExtensionInstalledEvent(installedExtension.getId(), targetNamespace), (Object)installedExtension);
            }
            catch (ExtensionException e) {
                this.logger.error("Failed to copy extension [{}] from namespace [{}] to namespace [{}]", new Object[]{installedExtension, sourceNamespace, targetNamespace, e});
            }
        }
    }

    private void onWikiDeleted(WikiDeletedEvent event) {
        String namespace = new WikiNamespace(event.getWikiId()).serialize();
        Collection installedExtensions = this.installedRepository.getInstalledExtensions(namespace);
        for (InstalledExtension installedExtension : installedExtensions) {
            if (installedExtension.isInstalled(null)) continue;
            try {
                this.installedRepository.uninstallExtension(installedExtension, namespace);
            }
            catch (UninstallException e) {
                this.logger.error("Failed to uninstall extension [{}] from namespace [{}]", new Object[]{installedExtension, namespace, e});
            }
        }
    }

    private void onWikiCreated(WikiCreatedEvent event, XWikiContext context) {
        String namespace = new WikiNamespace(event.getWikiId()).serialize();
        Collection installedExtensions = this.installedRepository.getInstalledExtensions(null);
        InstallRequest installRequest = new InstallRequest();
        DocumentReference userReference = context.getUserReference();
        if (userReference != null) {
            installRequest.setProperty(PROPERTY_USER_REFERENCE, (Object)userReference);
            installRequest.setExtensionProperty(PROPERTY_USER_REFERENCE, (Object)userReference.toString());
        }
        installRequest.setVerbose(false);
        installRequest.setInteractive(false);
        ExtensionHandler xarHandler = (ExtensionHandler)this.xarHandlerProvider.get();
        for (InstalledExtension installedExtension : installedExtensions) {
            if (!installedExtension.getType().equals("xar")) continue;
            installRequest.addExtension(installedExtension.getId());
            try {
                xarHandler.install((LocalExtension)installedExtension, namespace, (Request)installRequest);
            }
            catch (InstallException e) {
                this.logger.error("Failed to import extension [{}] in wiki [{}]", new Object[]{installedExtension, event.getWikiId(), e});
            }
        }
    }
}

