/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job.diff;

import com.xpn.xwiki.XWikiContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.display.Splitter;
import org.xwiki.diff.display.UnifiedDiffBlock;
import org.xwiki.diff.display.UnifiedDiffConfiguration;
import org.xwiki.diff.display.UnifiedDiffDisplayer;

public abstract class AbstractUnifiedDiffBuilder {
    protected static final String CONTENT = "content";
    @Inject
    protected Logger logger;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="line")
    private Splitter<String, String> lineSplitter;
    @Inject
    private Splitter<String, Character> charSplitter;
    @Inject
    private DiffManager diffManager;
    @Inject
    private UnifiedDiffDisplayer unifiedDiffDisplayer;

    protected boolean maybeAddDiff(Map<String, List<UnifiedDiffBlock<String, Character>>> diffs, String key, Object previousValue, Object nextValue) {
        List<UnifiedDiffBlock<String, Character>> diff;
        if (!Objects.equals(previousValue, nextValue) && (diff = this.createUnifiedDiff(previousValue == null ? null : previousValue.toString(), nextValue == null ? null : nextValue.toString())).size() > 0) {
            diffs.put(key, diff);
            return true;
        }
        return false;
    }

    private List<UnifiedDiffBlock<String, Character>> createUnifiedDiff(String previous, String next) {
        try {
            DiffResult diffResult = this.diffManager.diff(this.lineSplitter.split((Object)previous), this.lineSplitter.split((Object)next), null);
            UnifiedDiffConfiguration config = this.unifiedDiffDisplayer.getDefaultConfiguration();
            config.setSplitter(this.charSplitter);
            return this.unifiedDiffDisplayer.display(diffResult, config);
        }
        catch (DiffException e) {
            this.logger.warn("Failed to compute the differences. Root cause: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }
}

