/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.XWikiDocumentMerger;
import org.xwiki.extension.xar.XWikiDocumentMergerConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarEntryType;
import org.xwiki.xar.XarEntryTypeResolver;

@Component(roles={DocumentMergeImporter.class})
@Singleton
public class DocumentMergeImporter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private XWikiDocumentMerger defaultMerger;
    @Inject
    private XarEntryTypeResolver typeResolver;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;

    public void importDocument(String comment, XWikiDocument previousDocument, XWikiDocument currentDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        XarEntryType type = this.typeResolver.getDefault();
        XWikiDocumentMerger merger = this.defaultMerger;
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        XarEntry xarEntry = configuration.getXarEntry();
        if (xarEntry != null) {
            String reference = "document:" + (String)this.referenceSerializer.serialize((EntityReference)xarEntry, new Object[0]);
            XarEntryType configuredType = this.typeResolver.resolve(xarEntry, false);
            if (type != null && componentManager.hasComponent(XWikiDocumentMerger.class, type.getName())) {
                merger = (XWikiDocumentMerger)componentManager.getInstance(XWikiDocumentMerger.class, type.getName());
            } else if (componentManager.hasComponent(XWikiDocumentMerger.class, reference)) {
                merger = (XWikiDocumentMerger)componentManager.getInstance(XWikiDocumentMerger.class, reference);
            }
            if (configuredType != null) {
                type = configuredType;
            }
        }
        XWikiDocumentMergerConfiguration mergeConfiguration = new XWikiDocumentMergerConfiguration();
        mergeConfiguration.setAuthorReference(configuration.getUserReference());
        mergeConfiguration.setConflictActions(configuration.getConflictActions());
        mergeConfiguration.setType(this.getUpgradeType(type));
        XWikiDocument documentToSave = merger.merge(currentDocument != null && !currentDocument.isNew() ? currentDocument : null, previousDocument, nextDocument, mergeConfiguration);
        if (documentToSave != null && documentToSave != currentDocument) {
            this.saveDocument(documentToSave, comment, configuration);
        }
    }

    private XarEntryType.UpgradeType getUpgradeType(XarEntryType type) {
        if (type != null) {
            return type.getUpgradeType();
        }
        return null;
    }

    private void saveDocument(XWikiDocument document, String comment, PackageConfiguration configuration) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument currentDocument = xcontext.getWiki().getDocument(document.getDocumentReferenceWithLocale(), xcontext);
        if (!currentDocument.isNew()) {
            if (document != currentDocument) {
                if (document.isNew()) {
                    currentDocument.loadAttachmentsContentSafe(xcontext);
                    currentDocument.apply(document);
                } else {
                    currentDocument = document;
                }
            }
        } else {
            currentDocument = document;
        }
        this.setDocumentAuthor(currentDocument, document, configuration);
        this.saveDocumentSetContextUser(currentDocument, comment);
    }

    private void setDocumentAuthor(XWikiDocument currentDocument, XWikiDocument document, PackageConfiguration configuration) {
        DocumentReference configuredUser = configuration.getUserReference();
        if (configuredUser != null) {
            if (currentDocument.isNew()) {
                currentDocument.setCreatorReference(configuredUser);
            }
            currentDocument.setAuthorReference(configuredUser);
            currentDocument.setContentAuthorReference(configuredUser);
            for (XWikiAttachment attachment : currentDocument.getAttachmentList()) {
                if (!attachment.isContentDirty()) continue;
                attachment.setAuthorReference(currentDocument.getAuthorReference());
            }
        } else {
            if (document != currentDocument) {
                if (currentDocument.isNew()) {
                    currentDocument.setCreatorReference(document.getCreatorReference());
                }
                currentDocument.setAuthorReference(document.getAuthorReference());
                currentDocument.setContentAuthorReference(document.getContentAuthorReference());
                for (XWikiAttachment attachment : document.getAttachmentList()) {
                    if (!attachment.isContentDirty()) continue;
                    currentDocument.getAttachment(attachment.getFilename()).setAuthorReference(attachment.getAuthorReference());
                }
            }
            currentDocument.setContentDirty(false);
            currentDocument.setContentUpdateDate(new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentSetContextUser(XWikiDocument document, String comment) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        try {
            xcontext.setUserReference(document.getAuthorReference());
            xcontext.getWiki().saveDocument(document, comment, false, xcontext);
        }
        finally {
            xcontext.setUserReference(userReference);
        }
    }
}

