/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.security;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.xar.internal.security.XarSecurityTool;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.text.XWikiToStringBuilder;

public class XarSecurityRule
implements SecurityRule {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XarSecurityRule.class);
    private final Right right;
    private final boolean simple;
    private XarSecurityTool securityTool;

    public XarSecurityRule(Right right, boolean simple, XarSecurityTool securityTool) {
        this.right = right;
        this.simple = simple;
        this.securityTool = securityTool;
    }

    public boolean match(Right right) {
        return right == this.right;
    }

    public boolean match(GroupSecurityReference group) {
        return false;
    }

    public boolean match(UserSecurityReference user) {
        return !this.simple || this.securityTool.isSimpleUser(user.getOriginalDocumentReference());
    }

    public RuleState getState() {
        return RuleState.DENY;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.right).append(this.simple).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XarSecurityRule)) {
            return false;
        }
        XarSecurityRule rhs = (XarSecurityRule)object;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.right, (Object)rhs.right);
        builder.append(this.simple, rhs.simple);
        return builder.isEquals();
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("right", (Object)this.right);
        builder.append("simple", this.simple);
        return builder.toString();
    }
}

