/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.xar.XarExtensionException;
import org.xwiki.extension.xar.internal.doc.InstalledExtensionDocumentTree;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.extension.xar.internal.security.XarSecurityTool;
import org.xwiki.extension.xar.job.diff.DiffXarJobStatus;
import org.xwiki.extension.xar.job.diff.DocumentVersionReference;
import org.xwiki.extension.xar.question.ConflictQuestion;
import org.xwiki.extension.xar.security.ProtectionLevel;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.xar.XarException;

@Component
@Named(value="extension.xar")
@Singleton
public class XarExtensionScriptService
extends AbstractExtensionScriptService {
    @Inject
    private Packager packager;
    @Inject
    private AuthorizationManager genericAuthorization;
    @Inject
    private ContextualAuthorizationManager contextualAuthorization;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedXARs;
    @Inject
    private XarSecurityTool securityTool;
    @Inject
    private InstalledExtensionDocumentTree installedExtensionDocumentTree;

    private XarInstalledExtensionRepository getXarInstalledExtensionRepository() {
        return (XarInstalledExtensionRepository)this.installedXARs;
    }

    public Job repairInstalledExtension(String id, String version, String wiki) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setError((Exception)new JobException("Need programming right to repair a XAR"));
            return null;
        }
        String namespace = this.getWikiNamespace(wiki);
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(ExtensionRequest.getJobId((String)"action", (String)id, (String)namespace));
        DocumentReference currentUserReference = this.documentAccessBridge.getCurrentUserReference();
        if (currentUserReference != null) {
            installRequest.setProperty("user.reference", (Object)currentUserReference);
            installRequest.setExtensionProperty("user.reference", (Object)currentUserReference.toString());
        }
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("repairxar", (Request)installRequest);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return job;
    }

    public List<String> getDiffJobId(String feature, String namespace) {
        return ExtensionRequest.getJobId((String)"action", (String)feature, (String)namespace);
    }

    public Job diff(String feature, String wiki) {
        this.setError(null);
        String namespace = this.getWikiNamespace(wiki);
        InstallRequest installRequest = new InstallRequest();
        installRequest.addExtension(new ExtensionId(feature, (Version)null));
        if (namespace != null) {
            installRequest.addNamespace(namespace);
        }
        installRequest.setId(this.getDiffJobId(feature, namespace));
        try {
            return this.jobExecutor.execute("diffXar", (Request)installRequest);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    private String getWikiNamespace(String wiki) {
        return StringUtils.isNotBlank((CharSequence)wiki) ? "wiki:" + wiki : null;
    }

    public ConflictQuestion.ConflictType[] getConflictTypes() {
        return ConflictQuestion.ConflictType.values();
    }

    public boolean reset(DocumentReference reference, ExtensionId extensionId, List<String> jobId) {
        return this.reset(new DocumentVersionReference(reference, (Serializable)extensionId), jobId);
    }

    public boolean reset(DocumentReference reference, List<String> jobId) {
        this.setError(null);
        try {
            JobStatus jobStatus;
            this.genericAuthorization.checkAccess(Right.EDIT, ((XWikiContext)this.xcontextProvider.get()).getAuthorReference(), (EntityReference)reference);
            this.packager.reset(reference, ((XWikiContext)this.xcontextProvider.get()).getUserReference());
            if (jobId != null && (jobStatus = this.getJobStatus(jobId)) != null && jobStatus instanceof DiffXarJobStatus) {
                ((DiffXarJobStatus)jobStatus).reset(reference);
            }
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    public Collection<InstalledExtension> getInstalledExtensions(DocumentReference reference) {
        return (Collection)this.safe(this.getXarInstalledExtensionRepository().getXarInstalledExtensions(reference));
    }

    public Document getInstalledExtensionDocument(DocumentReference reference) throws XarExtensionException {
        try {
            return (Document)this.safe(this.packager.getXWikiDocument(reference));
        }
        catch (IOException | XarException e) {
            throw new XarExtensionException(String.format("Failed to get standard version of document [%s]", reference), e);
        }
    }

    public Document getInstalledExtensionDocument(DocumentReference reference, ExtensionId extensionId) throws XarExtensionException {
        try {
            return (Document)this.safe(this.packager.getXWikiDocument(reference, extensionId));
        }
        catch (IOException | XarException e) {
            throw new XarExtensionException(String.format("Failed to get standard version of document [%s] from extension with id [%s]", reference, extensionId), e);
        }
    }

    public Document getInstalledExtensionDocument(DocumentReference reference, XarInstalledExtension extension) throws XarExtensionException {
        try {
            return (Document)this.safe(this.packager.getXWikiDocument(reference, extension));
        }
        catch (IOException | XarException e) {
            throw new XarExtensionException(String.format("Failed to get standard version of document [%s] from extension [%s]", new Object[]{reference, extension}), e);
        }
    }

    public boolean isEditAllowed(DocumentReference documentReference) {
        return this.getXarInstalledExtensionRepository().isAllowed(documentReference, Right.EDIT);
    }

    public boolean isDeleteAllowed(DocumentReference documentReference) {
        return this.getXarInstalledExtensionRepository().isAllowed(documentReference, Right.DELETE);
    }

    public ProtectionLevel getEditSecurityLevel(DocumentReference userReference, DocumentReference documentReference) {
        return this.securityTool.getProtectionLevel(Right.EDIT, userReference, documentReference);
    }

    public ProtectionLevel getDeleteSecurityLevel(DocumentReference userReference, DocumentReference documentReference) {
        return this.securityTool.getProtectionLevel(Right.DELETE, userReference, documentReference);
    }

    public Boolean isExtensionDocument(DocumentReference documentReference) {
        if (this.contextualAuthorization.hasAccess(Right.VIEW, (EntityReference)documentReference)) {
            return this.installedExtensionDocumentTree.isExtensionPage(documentReference);
        }
        return null;
    }

    public Boolean isCustomizedExtensionDocument(DocumentReference documentReference) {
        if (this.contextualAuthorization.hasAccess(Right.VIEW, (EntityReference)documentReference)) {
            return this.installedExtensionDocumentTree.isCustomizedExtensionPage(documentReference);
        }
        return null;
    }
}

