/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.doc.merge.MergeConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.repository.XarLocalExtension;

@Component
@Singleton
@Named(value="xar")
public class XarExtensionHandler
extends AbstractExtensionHandler {
    private static final String WIKI_NAMESPACEPREFIX = "wiki:";
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private LocalExtensionRepository xarRepository;
    @Inject
    private Logger logger;

    public void install(LocalExtension localExtension, String namespace) throws InstallException {
        String wiki = namespace;
        if (wiki != null) {
            if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
            } else {
                throw new InstallException("Unsupported namespace [" + namespace + "], only " + WIKI_NAMESPACEPREFIX + "wikiid format is supported");
            }
        }
        this.install(null, localExtension, wiki);
    }

    public void upgrade(LocalExtension previousLocalExtension, LocalExtension newLocalExtension, String namespace) throws InstallException {
        List<XarEntry> newPages;
        XarLocalExtension previousXarExtension;
        String wiki = namespace;
        if (wiki != null) {
            if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
            } else {
                throw new InstallException("Unsupported namespace [" + namespace + "], only " + WIKI_NAMESPACEPREFIX + "wikiid format is supported");
            }
        }
        try {
            previousXarExtension = (XarLocalExtension)this.xarRepository.resolve(previousLocalExtension.getId());
        }
        catch (ResolveException e) {
            throw new InstallException("Failed to get xar extension [" + previousLocalExtension.getId() + "] from xar repository", (Throwable)e);
        }
        this.install(previousXarExtension, newLocalExtension, wiki);
        HashSet<XarEntry> previousPages = new HashSet<XarEntry>(previousXarExtension.getPages());
        try {
            XarLocalExtension newXarExtension = (XarLocalExtension)this.xarRepository.resolve(newLocalExtension.getId());
            newPages = newXarExtension.getPages();
        }
        catch (ResolveException e) {
            try {
                newPages = this.packager.getEntries(new File(newLocalExtension.getFile().getAbsolutePath()));
            }
            catch (IOException e1) {
                throw new InstallException("Failed to get xar extension [" + newLocalExtension.getId() + "] pages", (Throwable)e);
            }
        }
        for (XarEntry entry : newPages) {
            previousPages.remove(entry);
        }
        try {
            this.packager.unimportPages(previousPages, wiki);
        }
        catch (Exception e) {
            this.logger.warn("Exception when cleaning pages removed since previous xar extension version", (Throwable)e);
        }
    }

    private void install(XarLocalExtension previousExtension, LocalExtension localExtension, String wiki) throws InstallException {
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        try {
            this.packager.importXAR(previousExtension != null ? new XarFile(new File(previousExtension.getFile().getAbsolutePath()), previousExtension.getPages()) : null, new File(localExtension.getFile().getAbsolutePath()), wiki, mergeConfiguration);
        }
        catch (Exception e) {
            throw new InstallException("Failed to import xar for extension [" + localExtension + "]", (Throwable)e);
        }
    }

    public void uninstall(LocalExtension localExtension, String namespace) throws UninstallException {
        String wiki = namespace;
        if (wiki != null) {
            if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
            } else {
                throw new UninstallException("Unsupported namespace [" + namespace + "], only " + WIKI_NAMESPACEPREFIX + "wikiid format is supported");
            }
        }
        try {
            XarLocalExtension xarLocalExtension = (XarLocalExtension)this.xarRepository.resolve(localExtension.getId());
            List<XarEntry> pages = xarLocalExtension.getPages();
            this.packager.unimportPages(pages, wiki);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to get xar extension [" + localExtension.getId() + "] from xar repository", (Throwable)e);
        }
    }
}

