/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import java.util.zip.ZipEntry;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class XarEntry {
    private EntityReference documentReference;
    private String language;
    private ZipEntry zipEntry;

    public XarEntry() {
    }

    public XarEntry(String space, String page, String language) {
        this.documentReference = new EntityReference(page, EntityType.DOCUMENT, new EntityReference(space, EntityType.SPACE));
        this.language = language;
    }

    public XarEntry(EntityReference documentReference, String language) {
        this.documentReference = documentReference;
        this.language = language;
    }

    public EntityReference getDocumentReference() {
        return this.documentReference;
    }

    public void setDocumentReference(EntityReference documentReference) {
        this.documentReference = documentReference;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
    }

    public String toString() {
        return this.documentReference + ", language = [" + this.getLanguage() + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj == this) {
            equals = true;
        } else if (obj instanceof XarEntry) {
            XarEntry xarEntry = (XarEntry)obj;
            equals = this.getDocumentReference().equals((Object)xarEntry.getDocumentReference()) && this.getLanguage().equals(xarEntry.getLanguage());
        }
        return equals;
    }
}

