/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackager;
import org.xwiki.extension.xar.internal.handler.packager.NotADocumentException;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.handler.packager.xml.AttachmentHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.DocumentHandler;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class DocumentImporterHandler
extends DocumentHandler {
    private XarFile previousXarFile;
    private DefaultPackager packager;
    private XarEntryMergeResult mergeResult;
    private MergeConfiguration mergeConfiguration;

    public DocumentImporterHandler(DefaultPackager packager, ComponentManager componentManager, String wiki) {
        super(componentManager, wiki);
        this.packager = packager;
    }

    public void setPreviousXarFile(XarFile previousXarFile) {
        this.previousXarFile = previousXarFile;
    }

    public void setMergeConfiguration(MergeConfiguration mergeConfiguration) {
        this.mergeConfiguration = mergeConfiguration;
    }

    public XarEntryMergeResult getMergeResult() {
        return this.mergeResult;
    }

    private void saveDocument(XWikiDocument document, String comment, XWikiContext context) throws XWikiException {
        document.setAuthorReference(context.getUserReference());
        document.setContentAuthorReference(context.getUserReference());
        context.getWiki().saveDocument(document, comment, context);
    }

    private void saveDocument(String comment) throws SAXException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument document = this.getDocument();
            XWikiDocument dbDocument = this.getDatabaseDocument().clone();
            XWikiDocument previousDocument = this.getPreviousDocument();
            if (dbDocument != null && !dbDocument.isNew()) {
                if (previousDocument != null) {
                    MergeResult documentMergeResult = dbDocument.merge(previousDocument, document, this.mergeConfiguration, context);
                    if (documentMergeResult.isModified()) {
                        this.saveDocument(dbDocument, comment, context);
                    }
                    this.mergeResult = new XarEntryMergeResult(new XarEntry((EntityReference)dbDocument.getDocumentReference(), dbDocument.getLanguage()), documentMergeResult);
                } else if (dbDocument.apply(document)) {
                    this.saveDocument(dbDocument, comment, context);
                }
            } else {
                document.setCreatorReference(context.getUserReference());
                this.saveDocument(document, comment, context);
            }
        }
        catch (Exception e) {
            throw new SAXException("Failed to save document", e);
        }
    }

    private XWikiDocument getDatabaseDocument() throws ComponentLookupException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWikiDocument document = this.getDocument();
        XWikiDocument existingDocument = context.getWiki().getDocument(document.getDocumentReference(), context);
        if (StringUtils.isNotEmpty((CharSequence)document.getLanguage())) {
            String defaultLanguage = existingDocument.getDefaultLanguage();
            XWikiDocument translatedDocument = existingDocument.getTranslatedDocument(document.getLanguage(), context);
            if (translatedDocument == existingDocument) {
                translatedDocument = new XWikiDocument(document.getDocumentReference());
                translatedDocument.setDefaultLanguage(defaultLanguage);
                translatedDocument.setTranslation(1);
                translatedDocument.setLanguage(document.getLanguage());
            }
            existingDocument = translatedDocument;
        }
        return existingDocument;
    }

    private XWikiDocument getPreviousDocument() throws NotADocumentException, ParserConfigurationException, SAXException, IOException {
        XWikiDocument previousDocument = null;
        if (this.previousXarFile != null) {
            XWikiDocument document = this.getDocument();
            DocumentHandler documentHandler = new DocumentHandler(this.getComponentManager(), document.getWikiName());
            XarEntry realEntry = this.previousXarFile.getEntry(new EntityReference(document.getName(), EntityType.DOCUMENT, new EntityReference(document.getSpace(), EntityType.SPACE)), document.getRealLanguage());
            if (realEntry != null) {
                this.packager.parseDocument(this.previousXarFile.getInputStream(realEntry), documentHandler);
                previousDocument = documentHandler.getDocument();
            }
        }
        return previousDocument;
    }

    private void saveAttachment(XWikiAttachment attachment, String comment) throws SAXException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument document = this.getDocument();
            document.setAuthorReference(context.getUserReference());
            attachment.setAuthor(document.getAuthor());
            XWikiDocument dbDocument = this.getDatabaseDocument();
            XWikiAttachment dbAttachment = dbDocument.getAttachment(attachment.getFilename());
            if (dbAttachment == null) {
                dbDocument.getAttachmentList().add(attachment);
            } else {
                dbAttachment.setContent(attachment.getContentInputStream(context));
                dbAttachment.setFilename(attachment.getFilename());
                dbAttachment.setAuthor(attachment.getAuthor());
            }
            context.getWiki().saveDocument(dbDocument, comment, context);
            attachment.setAttachment_content(null);
            this.getDocument().getAttachmentList().add(attachment);
        }
        catch (Exception e) {
            throw new SAXException("Failed to save attachment [" + attachment + "]", e);
        }
    }

    @Override
    protected void endAttachment(String uri, String localName, String qName) throws SAXException {
        AttachmentHandler handler = (AttachmentHandler)this.getCurrentHandler();
        this.saveAttachment(handler.getAttachment(), "Import: add attachment");
    }

    @Override
    protected void endHandlerElement(String uri, String localName, String qName) throws SAXException {
        this.saveDocument(this.getDocument().getAttachmentList().isEmpty() ? "Import" : "Import: final save");
    }
}

