/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.xar.internal.script;

import javax.inject.Inject;

import org.xwiki.context.Execution;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;

/**
 * @version $Id: ab3f4c3af3c8dff3b831c63579e580cada8ce045 $
 * @since 4.0M2
 */
// TODO: Move this to oldcore when ScriptSafeProvider is to a public package
public class DocumentScriptSafeProvider implements ScriptSafeProvider<XWikiDocument>
{
    @Inject
    private Execution execution;

    private XWikiContext getXWikiContext()
    {
        return (XWikiContext) this.execution.getContext().getProperty(XWikiContext.EXECUTIONCONTEXT_KEY);
    }

    @Override
    public <S> S get(XWikiDocument unsafe)
    {
        return (S) unsafe.newDocument(getXWikiContext());
    }
}
