/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.xar.internal.handler.XarExtensionHandler;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="XarExtensionJobFinishedListener")
public class XarExtensionJobFinishedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new JobFinishedEvent("install"), new JobFinishedEvent("uninstall"));
    @Inject
    private Execution execution;
    @Inject
    private Provider<Packager> packagerProvider;
    @Inject
    private Logger logger;

    public String getName() {
        return "XarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object o, Object o1) {
        ExecutionContext context;
        JobFinishedEvent jobFinishedEvent = (JobFinishedEvent)event;
        if (!jobFinishedEvent.getRequest().isRemote() && (context = this.execution.getContext()) != null) {
            Map previousXAREntries = (Map)context.getProperty("extension.xar.installplan.previouspages");
            Map nextXAREntries = (Map)context.getProperty("extension.xar.installplan.pages");
            if (nextXAREntries != null) {
                Map rootNextPages = (Map)nextXAREntries.get(null);
                if (rootNextPages == null) {
                    rootNextPages = Collections.emptyMap();
                }
                for (Map.Entry entry : previousXAREntries.entrySet()) {
                    Map nextPages;
                    Map previousPages = (Map)entry.getValue();
                    Map map = nextPages = entry.getKey() != null ? (Map)nextXAREntries.get(entry.getKey()) : rootNextPages;
                    if (nextPages == null) {
                        nextPages = Collections.emptyMap();
                    }
                    HashMap previousPagesToDelete = new HashMap(previousPages);
                    for (XarEntry previousPage : previousPages.keySet()) {
                        if (!nextPages.containsKey(previousPage) && !rootNextPages.containsKey(previousPage)) continue;
                        previousPagesToDelete.remove(previousPage);
                    }
                    previousXAREntries.put(entry.getKey(), previousPagesToDelete);
                }
                for (Map.Entry previousWikiEntry : previousXAREntries.entrySet()) {
                    if (((Map)previousWikiEntry.getValue()).isEmpty()) continue;
                    try {
                        ((Packager)this.packagerProvider.get()).unimportPages(((Map)previousWikiEntry.getValue()).keySet(), this.createPackageConfiguration(jobFinishedEvent.getRequest(), (String)previousWikiEntry.getKey()));
                    }
                    catch (Exception e) {
                        this.logger.warn("Exception when cleaning pages removed since previous xar extension version", (Throwable)e);
                    }
                }
                context.setProperty("extension.xar.installplan.previouspages", null);
                context.setProperty("extension.xar.installplan.pages", null);
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(Request request, String wiki) {
        DefaultPackageConfiguration configuration = new DefaultPackageConfiguration();
        configuration.setInteractive(false);
        configuration.setUser(XarExtensionHandler.getRequestUserReference("user.reference", request));
        configuration.setWiki(wiki);
        configuration.setLogEnabled(true);
        return configuration;
    }
}

