/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.xml.sax.SAXException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.xml.AbstractHandler;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class XarPageLimitedHandler
extends AbstractHandler {
    private XarEntry xarEntry = new XarEntry();
    private EntityReference pageReference;

    public XarPageLimitedHandler(ComponentManager componentManager) {
        super(componentManager);
        this.setCurrentBean(this);
        this.pageReference = new EntityReference("page", EntityType.DOCUMENT, new EntityReference("space", EntityType.SPACE));
        this.addsupportedElements("name");
        this.addsupportedElements("web");
        this.addsupportedElements("language");
    }

    public XarEntry getXarEntry() {
        return this.xarEntry;
    }

    private Locale toLocale(String str) {
        Locale locale;
        try {
            locale = LocaleUtils.toLocale((String)str);
        }
        catch (Exception e) {
            locale = Locale.ROOT;
        }
        return locale;
    }

    @Override
    protected void endElementInternal(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("language")) {
            if (this.value.length() > 0) {
                this.xarEntry.setLocale(this.toLocale(this.value.toString()));
            } else {
                this.xarEntry.setLocale(Locale.ROOT);
            }
        } else if (qName.equals("name")) {
            this.pageReference = new EntityReference(this.value.toString(), EntityType.DOCUMENT, this.pageReference.getParent());
            this.xarEntry.setDocumentReference(this.pageReference);
        } else if (qName.equals("web")) {
            this.pageReference = this.pageReference.replaceParent(this.pageReference.getParent(), new EntityReference(this.value.toString(), EntityType.SPACE));
            this.xarEntry.setDocumentReference(this.pageReference);
        } else {
            super.endElementInternal(uri, localName, qName);
        }
    }
}

