/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.MandatoryDocumentInitializerManager;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.xar.internal.handler.ConflictQuestion;
import org.xwiki.extension.xar.internal.handler.packager.DocumentMergeImporter;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.logging.LogLevel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Singleton
public class DefaultDocumentMergeImporter
implements DocumentMergeImporter {
    static final String PROP_ALWAYS_MERGE = "extension.xar.packager.conflict.always.merge";
    static final String PROP_ALWAYS_NOMERGE = "extension.xar.packager.conflict.always.nomerge";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private MandatoryDocumentInitializerManager initializerManager;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    @Override
    public XarEntryMergeResult saveDocument(String comment, XWikiDocument previousDocument, XWikiDocument currentDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        XarEntryMergeResult mergeResult = null;
        if (configuration.isLogEnabled()) {
            this.logger.info("Importing document [{}] in language [{}]...", (Object)nextDocument.getDocumentReference(), (Object)nextDocument.getRealLocale());
        }
        if (currentDocument != null && !currentDocument.isNew()) {
            if (previousDocument != null) {
                mergeResult = this.merge(comment, currentDocument, previousDocument, nextDocument, configuration);
            } else {
                XWikiDocument mandatoryDocument = this.getMandatoryDocument(nextDocument.getDocumentReference());
                if (mandatoryDocument != null) {
                    mergeResult = this.merge(comment, currentDocument, mandatoryDocument, nextDocument, configuration);
                } else if (!currentDocument.equalsData(nextDocument)) {
                    XWikiDocument documentToSave;
                    if (configuration.isInteractive()) {
                        nextDocument.setCreatorReference(currentDocument.getCreatorReference());
                        DocumentReference userReference = configuration.getUserReference();
                        nextDocument.setAuthorReference(userReference);
                        nextDocument.setContentAuthorReference(userReference);
                        documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, null, configuration);
                    } else {
                        documentToSave = nextDocument;
                    }
                    if (documentToSave != currentDocument) {
                        this.saveDocument(documentToSave, comment, false, configuration);
                    }
                }
            }
        } else if (previousDocument == null) {
            this.saveDocument(nextDocument, comment, true, configuration);
        }
        return mergeResult;
    }

    private XarEntryMergeResult merge(String comment, XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument mergedDocument = currentDocument.clone();
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        mergeConfiguration.setProvidedVersionsModifiables(true);
        MergeResult documentMergeResult = mergedDocument.merge(previousDocument, nextDocument, mergeConfiguration, xcontext);
        if (configuration.isInteractive() && !documentMergeResult.getLog().getLogs(LogLevel.ERROR).isEmpty()) {
            XWikiDocument documentToSave;
            nextDocument.setCreatorReference(currentDocument.getCreatorReference());
            mergedDocument.setCreatorReference(currentDocument.getCreatorReference());
            DocumentReference userReference = configuration.getUserReference();
            if (userReference != null) {
                nextDocument.setAuthorReference(userReference);
                nextDocument.setContentAuthorReference(userReference);
                mergedDocument.setAuthorReference(userReference);
                mergedDocument.setContentAuthorReference(userReference);
            }
            if ((documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, mergedDocument, configuration)) != currentDocument) {
                this.saveDocument(documentToSave, comment, false, configuration);
            }
        } else if (documentMergeResult.isModified()) {
            this.saveDocument(mergedDocument, comment, false, configuration);
        }
        return new XarEntryMergeResult(new XarEntry(new LocalDocumentReference(mergedDocument.getDocumentReference()), mergedDocument.getLocale()), documentMergeResult);
    }

    private XWikiDocument getMandatoryDocument(DocumentReference documentReference) {
        XWikiDocument mandatoryDocument;
        MandatoryDocumentInitializer initializer = this.initializerManager.getMandatoryDocumentInitializer(documentReference);
        if (initializer != null) {
            mandatoryDocument = new XWikiDocument(documentReference);
            if (!initializer.updateDocument(mandatoryDocument)) {
                mandatoryDocument = null;
            }
        } else {
            mandatoryDocument = null;
        }
        return mandatoryDocument;
    }

    private ConflictQuestion.GlobalAction getMergeConflictAnswer(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument) {
        return (ConflictQuestion.GlobalAction)((Object)this.execution.getContext().getProperty(previousDocument != null ? PROP_ALWAYS_MERGE : PROP_ALWAYS_NOMERGE));
    }

    private void setMergeConflictAnswer(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, ConflictQuestion.GlobalAction action) {
        this.execution.getContext().setProperty(previousDocument != null ? PROP_ALWAYS_MERGE : PROP_ALWAYS_NOMERGE, (Object)action);
    }

    private XWikiDocument askDocumentToSave(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument, PackageConfiguration configuration) {
        XWikiDocument documentToSave;
        ConflictQuestion question = new ConflictQuestion(currentDocument, previousDocument, nextDocument, mergedDocument);
        if (mergedDocument == null) {
            question.setGlobalAction(ConflictQuestion.GlobalAction.NEXT);
        }
        if (configuration != null && configuration.getJobStatus() != null) {
            ConflictQuestion.GlobalAction contextAction = this.getMergeConflictAnswer(currentDocument, previousDocument, nextDocument);
            if (contextAction != null) {
                question.setGlobalAction(contextAction);
            } else {
                try {
                    configuration.getJobStatus().ask((Object)question);
                    if (question.isAlways()) {
                        this.setMergeConflictAnswer(currentDocument, previousDocument, nextDocument, question.getGlobalAction());
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        switch (question.getGlobalAction()) {
            case CURRENT: {
                documentToSave = currentDocument;
                break;
            }
            case NEXT: {
                documentToSave = nextDocument;
                break;
            }
            case PREVIOUS: {
                documentToSave = previousDocument;
                break;
            }
            case CUSTOM: {
                documentToSave = question.getCustomDocument() != null ? question.getCustomDocument() : mergedDocument;
                break;
            }
            default: {
                documentToSave = mergedDocument;
            }
        }
        return documentToSave;
    }

    private XWikiDocument getDatabaseDocument(XWikiDocument document, XWikiContext context) throws XWikiException {
        XWikiDocument existingDocument = context.getWiki().getDocument(document.getDocumentReference(), context);
        if (!document.getLocale().equals(Locale.ROOT)) {
            Locale defaultLocale = existingDocument.getDefaultLocale();
            XWikiDocument translatedDocument = existingDocument.getTranslatedDocument(document.getLocale(), context);
            if (translatedDocument == existingDocument) {
                translatedDocument = new XWikiDocument(document.getDocumentReference());
                translatedDocument.setDefaultLocale(defaultLocale);
                translatedDocument.setTranslation(1);
                translatedDocument.setLocale(document.getLocale());
            }
            existingDocument = translatedDocument;
        }
        return existingDocument;
    }

    private void saveDocument(XWikiDocument document, String comment, boolean setCreator, PackageConfiguration configuration) throws Exception {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument currentDocument = this.getDatabaseDocument(document, context);
        DocumentReference userReference = configuration.getUserReference();
        if (!currentDocument.isNew()) {
            if (document != currentDocument) {
                if (document.isNew()) {
                    currentDocument.apply(document);
                    if (setCreator) {
                        currentDocument.setCreatorReference(document.getCreatorReference());
                    }
                    currentDocument.setAuthorReference(document.getAuthorReference());
                    currentDocument.setContentAuthorReference(document.getContentAuthorReference());
                } else {
                    currentDocument = document;
                }
            }
        } else {
            currentDocument = document;
        }
        if (userReference != null) {
            if (setCreator) {
                currentDocument.setCreatorReference(userReference);
            }
            currentDocument.setAuthorReference(userReference);
            currentDocument.setContentAuthorReference(userReference);
        }
        this.saveDocumentSetContextUser(currentDocument, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentSetContextUser(XWikiDocument document, String comment) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        try {
            xcontext.setUserReference(document.getAuthorReference());
            xcontext.getWiki().saveDocument(document, comment, false, xcontext);
        }
        finally {
            xcontext.setUserReference(userReference);
        }
    }
}

