/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import com.xpn.xwiki.XWikiContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.properties.ConverterManager;

public class AbstractHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHandler.class);
    private ComponentManager componentManager;
    private ConverterManager converterManager;
    private Object currentBean;
    private ContentHandler currentHandler;
    private int currentHandlerLevel;
    private int depth = 0;
    protected StringBuffer value;
    protected Set<String> skippedElements = new HashSet<String>();
    protected Set<String> supportedElements;

    public AbstractHandler(ComponentManager componentManager) {
        this.componentManager = componentManager;
        try {
            this.converterManager = (ConverterManager)this.componentManager.getInstance(ConverterManager.class);
        }
        catch (ComponentLookupException e) {
            LOGGER.error("Failed to get default implementation of component role [{}]", ConverterManager.class);
        }
    }

    public AbstractHandler(ComponentManager componentManager, Object currentBean) {
        this(componentManager);
        this.currentBean = currentBean;
    }

    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected Object getCurrentBean() {
        return this.currentBean;
    }

    protected void setCurrentBean(Object currentBean) {
        this.currentBean = currentBean;
    }

    protected void addsupportedElements(String supportedElement) {
        if (this.supportedElements == null) {
            this.supportedElements = new HashSet<String>();
        }
        this.supportedElements.add(supportedElement);
    }

    public boolean isSupported(String elementName) {
        return !this.skippedElements.contains(elementName) && (this.supportedElements == null || this.supportedElements.contains(elementName));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentHandler == null) {
            if (this.depth == 0) {
                this.startHandlerElement(uri, localName, qName, attributes);
            } else if (this.depth == 1) {
                this.startElementInternal(uri, localName, qName, attributes);
            }
        }
        if (this.currentHandler != null) {
            this.currentHandler.startElement(uri, localName, qName, attributes);
        }
        ++this.depth;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.characters(ch, start, length);
        } else if (this.depth == 2) {
            this.charactersInternal(ch, start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        try {
            if (this.currentHandler != null) {
                this.currentHandler.endElement(uri, localName, qName);
                if (this.depth == this.currentHandlerLevel) {
                    this.endElementInternal(uri, localName, qName);
                    this.currentHandler = null;
                }
            } else if (this.depth == 0) {
                this.endHandlerElement(uri, localName, qName);
            } else if (this.depth == 1) {
                this.endElementInternal(uri, localName, qName);
            }
        }
        finally {
            this.value = null;
        }
    }

    protected void startElementInternal(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isSupported(qName)) {
            if (this.value == null) {
                this.value = new StringBuffer();
            } else {
                this.value.setLength(0);
            }
        }
    }

    protected void charactersInternal(char[] ch, int start, int length) throws SAXException {
        if (this.currentBean != null && this.value != null) {
            this.value.append(ch, start, length);
        }
    }

    protected void endElementInternal(String uri, String localName, String qName) throws SAXException {
        if (this.currentBean != null && this.value != null) {
            try {
                this.callMethod(qName);
                this.currentBeanModified();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set property [{}]", (Object)qName, (Object)e);
            }
        }
    }

    protected void callMethod(String name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String methodName = "set" + StringUtils.capitalize((String)name);
        try {
            Method setter = this.currentBean.getClass().getMethod(methodName, String.class);
            setter.invoke(this.currentBean, this.value.toString());
        }
        catch (NoSuchMethodException e) {
            for (Method medthod : this.currentBean.getClass().getMethods()) {
                if (medthod.getGenericParameterTypes().length != 1 || !medthod.getName().equals(methodName)) continue;
                Type type = medthod.getGenericParameterTypes()[0];
                if (type == String.class) {
                    medthod.invoke(this.currentBean, this.value.toString());
                    continue;
                }
                medthod.invoke(this.currentBean, this.converterManager.convert(type, (Object)this.value.toString()));
            }
        }
    }

    protected void currentBeanModified() {
    }

    protected void startHandlerElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    protected void endHandlerElement(String uri, String localName, String qName) throws SAXException {
    }

    protected void setCurrentHandler(ContentHandler currentHandler) {
        this.currentHandler = currentHandler;
        this.currentHandlerLevel = this.depth;
    }

    public ContentHandler getCurrentHandler() {
        return this.currentHandler;
    }

    protected ExecutionContext getExecutionContext() throws ComponentLookupException {
        return ((Execution)this.getComponentManager().getInstance(Execution.class)).getContext();
    }

    protected XWikiContext getXWikiContext() throws ComponentLookupException {
        return (XWikiContext)this.getExecutionContext().getProperty("xwikicontext");
    }
}

