/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackager;
import org.xwiki.extension.xar.internal.handler.packager.DocumentMergeImporter;
import org.xwiki.extension.xar.internal.handler.packager.NotADocumentException;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.handler.packager.xml.AttachmentHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.DocumentHandler;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public class DocumentImporterHandler
extends DocumentHandler {
    private DefaultPackager packager;
    private XarEntryMergeResult mergeResult;
    private PackageConfiguration configuration;
    private EntityReferenceSerializer<String> compactWikiSerializer = (EntityReferenceSerializer)this.getComponentManager().getInstance((Type)EntityReferenceSerializer.TYPE_STRING, "compactwiki");
    private DocumentMergeImporter importer;
    private Boolean hasCurrentDocument;

    public DocumentImporterHandler(DefaultPackager packager, ComponentManager componentManager, String wiki, DocumentMergeImporter importer) throws ComponentLookupException {
        super(componentManager, wiki);
        this.packager = packager;
        this.importer = importer;
    }

    public void setConfiguration(PackageConfiguration configuration) {
        this.configuration = configuration;
    }

    public XarEntryMergeResult getMergeResult() {
        return this.mergeResult;
    }

    private String getUserString() {
        return (String)this.compactWikiSerializer.serialize((EntityReference)this.configuration.getUserReference(), new Object[]{this.getDocument().getDocumentReference()});
    }

    private void saveDocumentSetContextUser(XWikiDocument document, String comment, boolean isMinorEdit, XWikiContext context) throws Exception {
        DocumentReference userReference = context.getUserReference();
        try {
            context.setUserReference(document.getAuthorReference());
            context.getWiki().saveDocument(document, comment, isMinorEdit, context);
        }
        catch (Exception e) {
            context.setUserReference(userReference);
        }
    }

    private void saveDocument(String comment) throws SAXException {
        try {
            XWikiDocument databaseDocument = this.getDatabaseDocument();
            this.mergeResult = this.importer.saveDocument(comment, this.getPreviousDocument(), (XWikiDocument)(this.hasCurrentDocument != false ? databaseDocument : null), this.getDocument(), this.configuration);
        }
        catch (Exception e) {
            throw new SAXException("Failed to save document", e);
        }
    }

    private XWikiDocument getDatabaseDocument() throws ComponentLookupException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWikiDocument document = this.getDocument();
        XWikiDocument existingDocument = context.getWiki().getDocument(document.getDocumentReference(), context);
        if (!document.getLocale().equals(Locale.ROOT)) {
            Locale defaultLocale = existingDocument.getDefaultLocale();
            XWikiDocument translatedDocument = existingDocument.getTranslatedDocument(document.getLocale(), context);
            if (translatedDocument == existingDocument) {
                translatedDocument = new XWikiDocument(document.getDocumentReference());
                translatedDocument.setDefaultLocale(defaultLocale);
                translatedDocument.setTranslation(1);
                translatedDocument.setLocale(document.getLocale());
            }
            existingDocument = translatedDocument;
        }
        if (this.hasCurrentDocument == null) {
            this.hasCurrentDocument = !existingDocument.isNew();
        }
        return existingDocument;
    }

    private XWikiDocument getPreviousDocument() throws NotADocumentException, ParserConfigurationException, SAXException, IOException {
        XWikiDocument previousDocument = null;
        XWikiDocument document = this.getDocument();
        XarEntry xarEntry = new XarEntry(document.getSpace(), document.getName(), document.getLocale());
        XarFile previousXarFile = this.configuration.getPreviousPages().get(xarEntry);
        if (previousXarFile != null) {
            DocumentHandler documentHandler = new DocumentHandler(this.getComponentManager(), document.getWikiName());
            XarEntry realEntry = previousXarFile.getEntry(xarEntry.getDocumentReference(), xarEntry.getLocale());
            if (realEntry != null) {
                this.packager.parseDocument(previousXarFile.getInputStream(realEntry), documentHandler);
                previousDocument = documentHandler.getDocument();
            }
        }
        return previousDocument;
    }

    private void saveAttachment(XWikiAttachment attachment, String comment) throws SAXException {
        try {
            XWikiDocument dbDocument;
            XWikiAttachment dbAttachment;
            XWikiContext context = this.getXWikiContext();
            XWikiDocument document = this.getDocument();
            DocumentReference userReference = this.configuration.getUserReference();
            if (userReference != null) {
                document.setAuthorReference(userReference);
                attachment.setAuthor(this.getUserString());
            }
            if ((dbAttachment = (dbDocument = this.getDatabaseDocument()).getAttachment(attachment.getFilename())) == null) {
                attachment.setDoc(dbDocument);
                dbDocument.getAttachmentList().add(attachment);
            } else {
                dbAttachment.setContent(attachment.getContentInputStream(context));
                dbAttachment.setFilename(attachment.getFilename());
                dbAttachment.setAuthor(attachment.getAuthor());
            }
            this.saveDocumentSetContextUser(dbDocument, comment, true, context);
            attachment.setAttachment_content(null);
            this.getDocument().getAttachmentList().add(attachment);
        }
        catch (Exception e) {
            throw new SAXException("Failed to save attachment [" + attachment + "]", e);
        }
    }

    @Override
    protected void endAttachment(String uri, String localName, String qName) throws SAXException {
        AttachmentHandler handler = (AttachmentHandler)this.getCurrentHandler();
        this.saveAttachment(handler.getAttachment(), "Import: add attachment");
    }

    @Override
    protected void endHandlerElement(String uri, String localName, String qName) throws SAXException {
        this.saveDocument(this.getDocument().getAttachmentList().isEmpty() ? "Import" : "Import: final save");
    }
}

