/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;

@Component
@Singleton
@Named(value="xar")
public class XarExtensionHandler
extends AbstractExtensionHandler {
    public static final String TYPE = "xar";
    protected static final String PROPERTY_USERREFERENCE = "user.reference";
    protected static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    protected static final String PROPERTY_CHECKRIGHTS = "checkrights";
    private static final String XWIKIPREFERENCES_FULLNAME = "XWiki.XWikiPreferences";
    private static final String RIGHTS_ADMIN = "admin";
    private static final TranslationMarker LOG_EXTENSIONPLAN_BEGIN = new TranslationMarker("extension.xar.log.extensionplan.begin");
    private static final TranslationMarker LOG_EXTENSIONPLAN_END = new TranslationMarker("extension.xar.log.extensionplan.end");
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private LocalExtensionRepository localReposirory;
    @Inject
    private Execution execution;

    protected static DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    private void initializePagesIndex(Request request) throws ExtensionException, XarException, IOException {
        XarExtensionPlan xarPlan;
        ExtensionPlan plan;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (plan = (ExtensionPlan)context.getProperty("job.extension.plan")) != null && (xarPlan = (XarExtensionPlan)context.getProperty("extension.xar.installplan")) == null) {
            if (request.isVerbose()) {
                this.logger.info((Marker)LOG_EXTENSIONPLAN_BEGIN, "Preparing XAR extension plan");
            }
            context.setProperty("extension.xar.installplan", (Object)new XarExtensionPlan(plan, this.xarRepository, this.localReposirory));
            if (request.isVerbose()) {
                this.logger.info((Marker)LOG_EXTENSIONPLAN_END, "XAR extension plan ready");
            }
        }
    }

    private XarExtensionPlan getXARExtensionPlan() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            return (XarExtensionPlan)context.getProperty("extension.xar.installplan");
        }
        return null;
    }

    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.installInternal(localExtension, wiki, request);
        }
    }

    public void upgrade(Collection<InstalledExtension> previousLocalExtensions, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.installInternal(newLocalExtension, wiki, request);
        }
    }

    private void installInternal(LocalExtension newLocalExtension, String wiki, Request request) throws InstallException {
        try {
            this.initializePagesIndex(request);
        }
        catch (Exception e) {
            throw new InstallException("Failed to initialize extension plan index", (Throwable)e);
        }
        PackageConfiguration configuration = this.createPackageConfiguration(newLocalExtension, request, wiki, this.getXARExtensionPlan());
        try {
            this.packager.importXAR("Install extensoin [" + newLocalExtension + "]", new File(newLocalExtension.getFile().getAbsolutePath()), configuration);
        }
        catch (Exception e) {
            throw new InstallException("Failed to import xar for extension [" + newLocalExtension + "]", (Throwable)e);
        }
    }

    public void uninstall(InstalledExtension installedExtension, String namespace, Request request) throws UninstallException {
        try {
            this.initializePagesIndex(request);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to initialize extension plan index", (Throwable)e);
        }
        if (!request.isRemote()) {
            Job currentJob;
            try {
                currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            }
            catch (ComponentLookupException e1) {
                currentJob = null;
            }
            if (currentJob == null) {
                String wiki;
                try {
                    wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
                }
                catch (UnsupportedNamespaceException e) {
                    throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                }
                PackageConfiguration configuration = this.createPackageConfiguration(null, request, wiki, this.getXARExtensionPlan());
                try {
                    XarInstalledExtension xarLocalExtension = (XarInstalledExtension)this.xarRepository.resolve(installedExtension.getId());
                    Collection pages = xarLocalExtension.getXarPackage().getEntries();
                    this.packager.unimportPages(pages, configuration);
                }
                catch (Exception e) {
                    throw new UninstallException("Failed to get xar extension [" + installedExtension.getId() + "] from xar repository", (Throwable)e);
                }
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(LocalExtension extension, Request request, String wiki, XarExtensionPlan xarExtensionPlan) {
        PackageConfiguration configuration = new PackageConfiguration();
        configuration.setInteractive(request.isInteractive());
        configuration.setUser(XarExtensionHandler.getRequestUserReference(PROPERTY_USERREFERENCE, request));
        configuration.setWiki(wiki);
        configuration.setVerbose(request.isVerbose());
        configuration.setSkipMandatorytDocuments(true);
        configuration.setXarExtensionPlan(xarExtensionPlan);
        try {
            Job currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            if (currentJob != null) {
                configuration.setJobStatus(currentJob.getStatus());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to lookup JobContext, it will be impossible to do interactive install");
        }
        if (extension != null) {
            Map<XarEntry, LocalExtension> nextXAREntriesOnWiki;
            Map<String, Map<XarEntry, LocalExtension>> nextXAREntries = this.getXARExtensionPlan().nextXAREntries;
            HashSet<String> entriesToImport = new HashSet<String>();
            Map<XarEntry, LocalExtension> nextXAREntriesOnRoot = nextXAREntries.get(null);
            if (nextXAREntriesOnRoot != null) {
                for (Map.Entry<XarEntry, LocalExtension> entry : nextXAREntriesOnRoot.entrySet()) {
                    if (entry.getValue() != extension) continue;
                    entriesToImport.add(entry.getKey().getEntryName());
                }
            }
            if ((nextXAREntriesOnWiki = nextXAREntries.get(wiki)) != null) {
                for (Map.Entry<XarEntry, LocalExtension> entry : nextXAREntriesOnWiki.entrySet()) {
                    if (entry.getValue() != extension) continue;
                    entriesToImport.add(entry.getKey().getEntryName());
                }
            }
            configuration.setEntriesToImport(entriesToImport);
        }
        return configuration;
    }

    private String getRequestUserString(String property, Request request) {
        String str = null;
        if (request.containsProperty(property)) {
            DocumentReference reference = XarExtensionHandler.getRequestUserReference(property, request);
            str = reference != null ? (String)this.serializer.serialize((EntityReference)reference, new Object[0]) : "XWiki.XWikiGuest";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAccessLevel(String wiki, String right, String document, Request request) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        boolean hasAccess = true;
        String currentWiki = xcontext.getDatabase();
        try {
            String user;
            xcontext.setDatabase(wiki != null ? wiki : xcontext.getMainXWiki());
            if (request.getProperty(PROPERTY_CALLERREFERENCE) != null) {
                String caller = this.getRequestUserString(PROPERTY_CALLERREFERENCE, request);
                hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, caller, document, xcontext);
            }
            if (hasAccess && (user = this.getRequestUserString(PROPERTY_USERREFERENCE, request)) != null) {
                hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, user, document, xcontext);
            }
        }
        finally {
            xcontext.setDatabase(currentWiki);
        }
        return hasAccess;
    }

    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        String wiki;
        try {
            wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
        }
        catch (UnsupportedNamespaceException e) {
            throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
        }
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(wiki, RIGHTS_ADMIN, XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new InstallException(String.format("Admin right is required to install extension [%s]", extension.getId()));
                    }
                    throw new InstallException(String.format("Admin right is required to install extension [%s] on namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new InstallException("Failed to check rights", (Throwable)e);
            }
        }
    }

    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        String wiki;
        try {
            wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
        }
        catch (UnsupportedNamespaceException e) {
            throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
        }
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(wiki, RIGHTS_ADMIN, XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new UninstallException(String.format("Admin right is required to uninstall extension [%s]", extension.getId()));
                    }
                    throw new UninstallException(String.format("Admin right is required to uninstall extension [%s] from namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new UninstallException("Failed to check rights", (Throwable)e);
            }
        }
    }
}

