/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializerManager;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.handler.packager.DocumentMergeImporter;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.extension.xar.internal.handler.packager.XarMergeResult;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.BeanInputFilterStream;
import org.xwiki.filter.input.BeanInputFilterStreamFactory;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.instance.internal.output.XWikiDocumentOutputFilterStream;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.logging.marker.BeginTranslationMarker;
import org.xwiki.logging.marker.EndTranslationMarker;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarFile;

@Component(roles={Packager.class})
@Singleton
public class Packager {
    private static final BeginTranslationMarker LOG_INSTALLDOCUMENT_BEGIN = new BeginTranslationMarker("extension.xar.log.install.document.begin");
    private static final EndTranslationMarker LOG_INSTALLDOCUMENT_SUCCESS_END = new EndTranslationMarker("extension.xar.log.install.document.success.end");
    private static final EndTranslationMarker LOG_INSTALLDOCUMENT_FAILURE_END = new EndTranslationMarker("extension.xar.log.install.document.failure.end");
    private static final TranslationMarker LOG_DELETEDDOCUMENT = new TranslationMarker("extension.xar.log.delete.document");
    private static final TranslationMarker LOG_DELETEDDOCUMENT_FAILURE = new TranslationMarker("extension.xar.log.delete.document.failure");
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    private Logger logger;
    @Inject
    private ObservationManager observation;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentMergeImporter importer;
    @Inject
    private MandatoryDocumentInitializerManager initializerManager;
    @Inject
    @Named(value="xwiki+xar/1.2")
    private InputFilterStreamFactory xarFilterStreamFactory;

    public void importXAR(String comment, File xarFile, PackageConfiguration configuration) throws IOException, XWikiException, ComponentLookupException, FilterException {
        if (configuration.getWiki() == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            List wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            for (String subwiki : wikis) {
                this.importXARToWiki(comment, xarFile, new WikiReference(subwiki), configuration);
            }
        } else {
            this.importXARToWiki(comment, xarFile, new WikiReference(configuration.getWiki()), configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XarMergeResult importXARToWiki(String comment, File xarFile, WikiReference wikiReference, PackageConfiguration configuration) throws IOException, ComponentLookupException, XWikiException, FilterException {
        try (FileInputStream fis = new FileInputStream(xarFile);){
            XarMergeResult xarMergeResult = this.importXARToWiki(comment, fis, wikiReference, configuration);
            return xarMergeResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XarMergeResult importXARToWiki(String comment, InputStream xarInputStream, WikiReference wikiReference, PackageConfiguration configuration) throws IOException, ComponentLookupException, XWikiException, FilterException {
        XarMergeResult mergeResult = new XarMergeResult();
        ZipArchiveInputStream zis = new ZipArchiveInputStream(xarInputStream);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentWiki = xcontext.getWikiId();
        try {
            xcontext.setWikiId(wikiReference.getName());
            this.observation.notify((Event)new XARImportingEvent(), null, (Object)xcontext);
            ArchiveEntry entry = zis.getNextEntry();
            while (entry != null) {
                XarEntryMergeResult entityMergeResult;
                if (!(entry.isDirectory() || entry.getName().equals("package.xml") || configuration.getEntriesToImport() != null && !configuration.getEntriesToImport().contains(entry.getName()) || (entityMergeResult = this.importDocumentToWiki(comment, wikiReference, (InputStream)zis, configuration)) == null)) {
                    mergeResult.addMergeResult(entityMergeResult);
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            this.observation.notify((Event)new XARImportedEvent(), null, (Object)xcontext);
            xcontext.setWikiId(currentWiki);
        }
        return mergeResult;
    }

    private XarEntryMergeResult importDocumentToWiki(String comment, WikiReference wikiReference, InputStream inputStream, PackageConfiguration configuration) throws XWikiException, FilterException, ComponentLookupException, IOException {
        XWikiDocument nextDocument;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            nextDocument = this.getXWikiDocument(inputStream, wikiReference);
        }
        catch (Exception e) {
            this.logger.error("Failed to parse document", (Throwable)e);
            return null;
        }
        DocumentReference reference = nextDocument.getDocumentReferenceWithLocale();
        XWikiDocument currentDocument = xcontext.getWiki().getDocument(reference, xcontext);
        currentDocument.loadAttachmentsContent(xcontext);
        XarExtensionPlan xarExtensionPlan = configuration.getXarExtensionPlan();
        XWikiDocument previousDocument = xarExtensionPlan != null ? xarExtensionPlan.getPreviousXWikiDocument(reference, this) : null;
        if (configuration.isVerbose()) {
            this.logger.info((Marker)LOG_INSTALLDOCUMENT_BEGIN, "Installing document [{}]", (Object)nextDocument.getDocumentReferenceWithLocale());
        }
        try {
            XarEntryMergeResult entityMergeResult = this.importer.saveDocument(comment, previousDocument, currentDocument, nextDocument, configuration);
            if (configuration.isVerbose()) {
                this.logger.info((Marker)LOG_INSTALLDOCUMENT_SUCCESS_END, "Done installing document [{}]", (Object)nextDocument.getDocumentReferenceWithLocale());
            }
            return entityMergeResult;
        }
        catch (Exception e) {
            if (configuration.isVerbose()) {
                this.logger.error((Marker)LOG_INSTALLDOCUMENT_FAILURE_END, "Failed to install document [{}]", (Object)nextDocument.getDocumentReferenceWithLocale(), (Object)e);
            }
            return null;
        }
    }

    public void unimportPages(Collection<XarEntry> pages, PackageConfiguration configuration) throws XWikiException {
        if (configuration.getWiki() == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            List wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            for (String subwiki : wikis) {
                this.unimportPagesFromWiki(pages, subwiki, configuration);
            }
        } else {
            this.unimportPagesFromWiki(pages, configuration.getWiki(), configuration);
        }
    }

    private void unimportPagesFromWiki(Collection<XarEntry> entries, String wiki, PackageConfiguration configuration) {
        WikiReference wikiReference = new WikiReference(wiki);
        for (XarEntry xarEntry : entries) {
            if (configuration.getEntriesToImport() != null && !configuration.getEntriesToImport().contains(xarEntry.getEntryName())) continue;
            DocumentReference documentReference = new DocumentReference((EntityReference)this.resolver.resolve((Object)xarEntry, new Object[]{wikiReference}), xarEntry.getLocale());
            if (configuration.isSkipMandatorytDocuments() && this.isMandatoryDocument(documentReference)) continue;
            this.deleteDocument(documentReference, configuration);
        }
    }

    public void deleteDocument(DocumentReference documentReference, PackageConfiguration configuration) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document;
            if (configuration.getUserReference() != null) {
                xcontext.setUserReference(configuration.getUserReference());
            }
            if (!(document = xcontext.getWiki().getDocument(documentReference, xcontext)).isNew()) {
                xcontext.getWiki().deleteDocument(document, xcontext);
                if (configuration.isVerbose()) {
                    this.logger.info((Marker)LOG_DELETEDDOCUMENT, "Deleted document [{}]", (Object)document.getDocumentReferenceWithLocale());
                }
            }
        }
        catch (XWikiException e) {
            this.logger.error((Marker)LOG_DELETEDDOCUMENT_FAILURE, "Failed to delete document [{}]", (Object)documentReference, (Object)e);
        }
    }

    private boolean isMandatoryDocument(DocumentReference documentReference) {
        return this.initializerManager.getMandatoryDocumentInitializer(documentReference) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiDocument getXWikiDocument(WikiReference wikiReference, LocalDocumentReference documentReference, XarFile xarFile) throws FilterException, ComponentLookupException, IOException {
        XarEntry realEntry = xarFile.getEntry(documentReference);
        if (realEntry != null) {
            try (InputStream stream = xarFile.getInputStream((LocalDocumentReference)realEntry);){
                XWikiDocument xWikiDocument = this.getXWikiDocument(stream, wikiReference);
                return xWikiDocument;
            }
        }
        return null;
    }

    public XWikiDocument getXWikiDocument(InputStream stream, WikiReference wikiReference) throws FilterException, ComponentLookupException, IOException {
        DocumentInstanceOutputProperties documentProperties = new DocumentInstanceOutputProperties();
        documentProperties.setDefaultReference((EntityReference)wikiReference);
        documentProperties.setVersionPreserved(false);
        documentProperties.setAuthorPreserved(true);
        XWikiDocumentOutputFilterStream documentFilter = (XWikiDocumentOutputFilterStream)this.componentManager.getInstance(XWikiDocumentOutputFilterStream.class);
        documentFilter.setProperties(documentProperties);
        XARInputProperties xarProperties = new XARInputProperties();
        xarProperties.setForceDocument(true);
        xarProperties.setWithHistory(false);
        xarProperties.setSource((InputSource)new DefaultInputStreamInputSource(stream));
        BeanInputFilterStream xarFilterStream = ((BeanInputFilterStreamFactory)this.xarFilterStreamFactory).createInputFilterStream((Object)xarProperties);
        xarFilterStream.read((Object)documentFilter);
        xarFilterStream.close();
        return documentFilter.getDocument();
    }

    public List<DocumentReference> getDocumentReferences(Collection<XarEntry> pages, PackageConfiguration configuration) throws XWikiException {
        ArrayList<DocumentReference> documents = new ArrayList<DocumentReference>(pages.size());
        if (configuration.getWiki() == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            List wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            for (String subwiki : wikis) {
                this.getDocumentReferencesFromWiki(documents, pages, subwiki, configuration);
            }
        } else {
            this.getDocumentReferencesFromWiki(documents, pages, configuration.getWiki(), configuration);
        }
        return documents;
    }

    private void getDocumentReferencesFromWiki(List<DocumentReference> documents, Collection<XarEntry> pages, String wiki, PackageConfiguration configuration) {
        WikiReference wikiReference = new WikiReference(wiki);
        for (XarEntry xarEntry : pages) {
            if (configuration.getEntriesToImport() != null && !configuration.getEntriesToImport().contains(xarEntry.getEntryName())) continue;
            DocumentReference documentReference = new DocumentReference((LocalDocumentReference)xarEntry, wikiReference);
            if (configuration.isSkipMandatorytDocuments() && this.isMandatoryDocument(documentReference)) continue;
            documents.add(documentReference);
        }
    }
}

