/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Request;
import org.xwiki.logging.marker.BeginTranslationMarker;
import org.xwiki.logging.marker.EndTranslationMarker;
import org.xwiki.observation.event.Event;

@Component
@Named(value="repairxar")
public class RepairXarJob
extends AbstractExtensionJob<InstallRequest, DefaultJobStatus<InstallRequest>> {
    public static final String JOBTYPE = "repairxar";
    private static final BeginTranslationMarker LOG_REPAIR_BEGIN = new BeginTranslationMarker("extension.xar.log.repair.begin");
    private static final BeginTranslationMarker LOG_REPAIR_NAMESPACE_BEGIN = new BeginTranslationMarker("extension.xar.log.repair.begin.namespace");
    private static final EndTranslationMarker LOG_REPAIR_END = new EndTranslationMarker("extension.xar.log.repair.end");
    private static final EndTranslationMarker LOG_REPAIR_END_NAMESPACE = new EndTranslationMarker("extension.xar.log.repair.end.namespace");
    @Inject
    protected ExtensionRepositoryManager repositoryManager;
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private LocalExtensionRepository localRepository;
    @Inject
    private CoreExtensionRepository coreRepository;

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        this.progressManager.pushLevelProgress(((InstallRequest)this.getRequest()).getExtensions().size(), (Object)this);
        try {
            for (ExtensionId extensionId : ((InstallRequest)this.getRequest()).getExtensions()) {
                this.progressManager.startStep((Object)this);
                if (((InstallRequest)this.getRequest()).getNamespaces() != null) {
                    this.progressManager.pushLevelProgress(((InstallRequest)this.getRequest()).getNamespaces().size(), (Object)this);
                    try {
                        for (String namespace : ((InstallRequest)this.getRequest()).getNamespaces()) {
                            this.progressManager.startStep((Object)this);
                            this.repairExtension(extensionId, namespace, false);
                        }
                        continue;
                    }
                    finally {
                        this.progressManager.popLevelProgress((Object)this);
                        continue;
                    }
                }
                this.repairExtension(extensionId, null, false);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LocalExtension getLocalXARExtension(ExtensionId extensionId) throws InstallException {
        LocalExtension localExtension = this.localRepository.getLocalExtension(extensionId);
        if (localExtension == null) {
            this.progressManager.pushLevelProgress(2, (Object)this);
            try {
                this.progressManager.startStep((Object)this);
                Extension extension = this.repositoryManager.resolve(extensionId);
                this.progressManager.startStep((Object)this);
                if (!extension.getType().equals("xar")) return localExtension;
                localExtension = this.localExtensionRepository.storeExtension(extension);
                return localExtension;
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to find extension", (Throwable)e);
            }
            catch (LocalExtensionRepositoryException e) {
                throw new InstallException("Failed save extension in local repository", (Throwable)e);
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
            }
        } else {
            if (localExtension.getType().equals("xar")) return localExtension;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairExtension(ExtensionId extensionId, String namespace, boolean dependency) throws InstallException {
        if (this.installedRepository.getInstalledExtension(extensionId.getId(), namespace) != null) {
            this.logger.debug("Extension [{}] already installed on namespace [{}]", (Object)extensionId.getId(), (Object)namespace);
            return;
        }
        if (((InstallRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_REPAIR_NAMESPACE_BEGIN, "Repairing XAR extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_REPAIR_BEGIN, "Repairing XAR extension [{}] on all namespaces", (Object)extensionId, (Object)namespace);
            }
        }
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            LocalExtension localExtension = this.getLocalXARExtension(extensionId);
            this.progressManager.startStep((Object)this);
            if (localExtension != null) {
                this.repairExtension(localExtension, namespace, dependency);
            }
        }
        finally {
            if (((InstallRequest)this.getRequest()).isVerbose()) {
                if (namespace != null) {
                    this.logger.info((Marker)LOG_REPAIR_END_NAMESPACE, "Done repairing XAR extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
                } else {
                    this.logger.info((Marker)LOG_REPAIR_END, "Done repairing XAR extension [{}] on all namespaces", (Object)extensionId, (Object)namespace);
                }
            }
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairExtension(LocalExtension localExtension, String namespace, boolean dependency) throws InstallException {
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            Collection dependencies = localExtension.getDependencies();
            if (!dependencies.isEmpty()) {
                this.progressManager.pushLevelProgress(dependencies.size(), (Object)this);
                try {
                    for (ExtensionDependency extensionDependency : dependencies) {
                        this.progressManager.startStep((Object)this);
                        this.repairDependency(extensionDependency, namespace);
                    }
                }
                finally {
                    this.progressManager.popLevelProgress((Object)this);
                }
            }
            this.progressManager.startStep((Object)this);
            InstalledExtension installedExtension = this.installedRepository.installExtension(localExtension, namespace, dependency);
            this.observationManager.notify((Event)new ExtensionInstalledEvent(installedExtension.getId(), namespace), (Object)installedExtension);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void repairDependency(ExtensionDependency extensionDependency, String namespace) {
        if (this.coreRepository.getCoreExtension(extensionDependency.getId()) == null) {
            if (extensionDependency.getVersionConstraint().getVersion() == null) {
                this.logger.warn("Can't repair extension dependency [{}] with version range ([{}]) since there is no way to know what has been installed", (Object)extensionDependency.getId(), (Object)extensionDependency.getVersionConstraint());
            } else {
                try {
                    this.repairExtension(new ExtensionId(extensionDependency.getId(), extensionDependency.getVersionConstraint().getVersion()), namespace, true);
                }
                catch (InstallException e) {
                    this.logger.warn("Failed to repair dependency [{}]", (Object)extensionDependency, (Object)e);
                }
            }
        }
    }
}

