/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.XarExtensionHandler;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlanEntry;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.extension.xar.question.CleanPagesQuestion;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobFinishingEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.xar.XarEntry;

@Component
@Singleton
@Named(value="XarExtensionJobFinishedListener")
public class XarExtensionJobFinishedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new JobFinishingEvent("install"), new JobFinishingEvent("uninstall"));
    @Inject
    private Execution execution;
    @Inject
    private Provider<Packager> packagerProvider;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;

    public String getName() {
        return "XarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        XarExtensionPlan xarExtensionPlan;
        ExecutionContext context;
        JobFinishingEvent jobFinishingEvent = (JobFinishingEvent)event;
        if (!jobFinishingEvent.getRequest().isRemote() && (context = this.execution.getContext()) != null && (xarExtensionPlan = (XarExtensionPlan)context.getProperty("extension.xar.installplan")) != null) {
            try {
                Map<String, Map<XarEntry, XarExtensionPlanEntry>> previousXAREntries = xarExtensionPlan.previousXAREntries;
                Map<String, Map<XarEntry, LocalExtension>> nextXAREntries = xarExtensionPlan.nextXAREntries;
                Map<Object, Object> rootNextPages = nextXAREntries.get(null);
                if (rootNextPages == null) {
                    rootNextPages = Collections.emptyMap();
                }
                XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                Packager packager = (Packager)this.packagerProvider.get();
                HashSet<DocumentReference> pagesToDelete = new HashSet<DocumentReference>();
                for (Map.Entry<String, Map<XarEntry, XarExtensionPlanEntry>> previousWikiEntry : previousXAREntries.entrySet()) {
                    if (previousWikiEntry.getValue().isEmpty()) continue;
                    try {
                        List<DocumentReference> references = packager.getDocumentReferences(previousWikiEntry.getValue().keySet(), this.createPackageConfiguration(jobFinishingEvent.getRequest(), previousWikiEntry.getKey()));
                        for (DocumentReference documentReference : references) {
                            if (!((XarInstalledExtensionRepository)this.xarRepository).getXarInstalledExtensions(documentReference).isEmpty()) continue;
                            pagesToDelete.add(documentReference);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Exception when cleaning pages removed since previous xar extension version", (Throwable)e);
                    }
                }
                CleanPagesQuestion question = new CleanPagesQuestion(pagesToDelete);
                Map<DocumentReference, Boolean> pages = question.getPages();
                for (DocumentReference documentReference : pagesToDelete) {
                    if (!xarExtensionPlan.containsNewPage(documentReference)) continue;
                    pages.remove(documentReference);
                }
                for (Map.Entry entry : pages.entrySet()) {
                    XWikiDocument previousDocument;
                    XWikiDocument currentDocument;
                    DocumentReference documentReference = (DocumentReference)entry.getKey();
                    try {
                        currentDocument = xcontext.getWiki().getDocument(documentReference, xcontext);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to get document [{}]", (Object)documentReference, (Object)e);
                        pages.put(documentReference, false);
                        continue;
                    }
                    if (currentDocument.isNew()) {
                        pages.put(documentReference, false);
                        continue;
                    }
                    try {
                        previousDocument = xarExtensionPlan.getPreviousXWikiDocument(documentReference, packager);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to get previous version of document [{}]", (Object)documentReference, (Object)e);
                        pages.put(documentReference, false);
                        continue;
                    }
                    try {
                        currentDocument.loadAttachmentsContent(xcontext);
                        if (currentDocument.equalsData(previousDocument)) continue;
                        pages.put(documentReference, false);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to load attachments", (Throwable)e);
                        pages.put(documentReference, false);
                    }
                }
                if (!pages.isEmpty() && jobFinishingEvent.getRequest().isInteractive()) {
                    try {
                        ((Job)source).getStatus().ask((Object)question);
                    }
                    catch (InterruptedException e) {
                        this.logger.warn("The thread has been interrupted", (Throwable)e);
                        try {
                            xarExtensionPlan.close();
                        }
                        catch (IOException iOException) {
                            this.logger.error("Failed to close XAR extension plan", (Throwable)iOException);
                        }
                        context.setProperty("extension.xar.installplan", null);
                        return;
                    }
                }
                PackageConfiguration configuration = this.createPackageConfiguration(jobFinishingEvent.getRequest());
                for (Map.Entry<DocumentReference, Boolean> entry : pages.entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    packager.deleteDocument(entry.getKey(), configuration);
                }
            }
            finally {
                try {
                    xarExtensionPlan.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close XAR extension plan", (Throwable)e);
                }
                context.setProperty("extension.xar.installplan", null);
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(Request request) {
        return this.createPackageConfiguration(request, null);
    }

    private PackageConfiguration createPackageConfiguration(Request request, String wiki) {
        PackageConfiguration configuration = new PackageConfiguration();
        configuration.setInteractive(false);
        configuration.setUser(XarExtensionHandler.getRequestUserReference("user.reference", request));
        configuration.setWiki(wiki);
        configuration.setVerbose(request.isVerbose());
        configuration.setSkipMandatorytDocuments(true);
        return configuration;
    }
}

