/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.script;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.extension.version.Version;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.stability.Unstable;

@Component
@Named(value="extension.xar")
@Singleton
public class XarExtensionScriptService
extends AbstractExtensionScriptService {
    private static final String PROPERTY_USER_REFERENCE = "user.reference";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private JobExecutor jobExecutor;

    public Job repairInstalledExtension(String id, String version, String wiki) {
        this.setError(null);
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            this.setError((Exception)new JobException("Need programming right to repair a XAR"));
            return null;
        }
        String namespace = this.getWikiNamespace(wiki);
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId("action", id, namespace));
        DocumentReference currentUserReference = this.documentAccessBridge.getCurrentUserReference();
        if (currentUserReference != null) {
            installRequest.setProperty(PROPERTY_USER_REFERENCE, (Object)currentUserReference);
            installRequest.setExtensionProperty(PROPERTY_USER_REFERENCE, (Object)currentUserReference.toString());
        }
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("repairxar", (Request)installRequest);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return job;
    }

    @Unstable
    public Job diff(String feature, String wiki) {
        this.setError(null);
        InstallRequest installRequest = new InstallRequest();
        installRequest.addExtension(new ExtensionId(feature, (Version)null));
        if (StringUtils.isNotBlank((CharSequence)wiki)) {
            installRequest.addNamespace(this.getWikiNamespace(wiki));
        }
        installRequest.setId(this.getJobId("action", feature, installRequest.hasNamespaces() ? (String)installRequest.getNamespaces().iterator().next() : null));
        try {
            return this.jobExecutor.execute("diffXar", (Request)installRequest);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    private String getWikiNamespace(String wiki) {
        return "wiki:" + wiki;
    }

    private List<String> getJobId(String prefix, String extensionId, String namespace) {
        List<String> jobId = namespace != null ? Arrays.asList("extension", prefix, extensionId, namespace) : Arrays.asList("extension", prefix, extensionId);
        return jobId;
    }
}

