/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceValidator;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.ExtensionRewriter;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.extension.script.CoreExtensionScriptService;
import org.xwiki.extension.script.InstalledExtensionScriptService;
import org.xwiki.extension.script.LocalExtensionScriptService;
import org.xwiki.extension.script.ScriptExtensionRewriter;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionRange;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="extension")
@Singleton
public class ExtensionManagerScriptService
extends AbstractExtensionScriptService {
    public static final String ROLEHINT = "extension";
    @Deprecated
    public static final String EXTENSION_JOBID_PREFIX = "extension";
    @Deprecated
    public static final String EXTENSIONACTION_JOBID_PREFIX = "action";
    @Deprecated
    public static final String EXTENSIONPLAN_JOBID_PREFIX = "plan";
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private NamespaceValidator namespaceResolver;
    @Inject
    private ExtensionFactory factory;

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("extension." + serviceName);
    }

    public Collection<ExtensionRepository> getRepositories() {
        return (Collection)this.safe(this.repositoryManager.getRepositories());
    }

    public ExtensionRepository getRepository(String repositoryId) {
        return (ExtensionRepository)this.safe(this.extensionManager.getRepository(repositoryId));
    }

    public IterableResult<Extension> search(String pattern, int offset, int nb) {
        this.setError(null);
        IterableResult<Extension> result = null;
        try {
            return this.repositoryManager.search(pattern, offset, nb);
        }
        catch (Exception e) {
            this.setError(e);
            return result;
        }
    }

    public IterableResult<Extension> search(ExtensionQuery query) {
        this.setError(null);
        IterableResult result = null;
        try {
            result = this.repositoryManager.search(query);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return result;
    }

    public ExtensionQuery newQuery(String query) {
        return new ExtensionQuery(query);
    }

    public Extension resolve(String id, String version) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = (Extension)this.safe(this.extensionManager.resolveExtension(new ExtensionId(id, version)));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    @Deprecated
    public Extension resolve(ExtensionDependency extensionDependency) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = (Extension)this.safe(this.extensionManager.resolveExtension(extensionDependency));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    public Extension resolve(ExtensionDependency extensionDependency, String namespace) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = (Extension)this.safe(this.extensionManager.resolveExtension(extensionDependency, namespace));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) {
        this.setError(null);
        IterableResult versions = null;
        try {
            versions = this.repositoryManager.resolveVersions(id, offset, nb);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return versions;
    }

    public ExtensionId createExtensionId(String id, String version) {
        return new ExtensionId(id, version);
    }

    public InstallRequest createInstallRequest(String id, String version, String namespace) {
        InstallRequest installRequest = this.createInstallPlanRequest(id, version, namespace);
        installRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONACTION_JOBID_PREFIX, (String)id, (String)namespace));
        return installRequest;
    }

    public Job install(String id, String version, String namespace) {
        return this.install(this.createInstallRequest(id, version, namespace));
    }

    public Job install(InstallRequest installRequest) {
        DocumentReference currentUserReference;
        this.setError(null);
        if (installRequest.getId() == null || installRequest.getId().size() > 2 && ((String)installRequest.getId().get(1)).equals(EXTENSIONPLAN_JOBID_PREFIX)) {
            String extensionId = ((ExtensionId)installRequest.getExtensions().iterator().next()).getId();
            String namespace = installRequest.getNamespaces() == null ? null : (String)installRequest.getNamespaces().iterator().next();
            installRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONACTION_JOBID_PREFIX, (String)extensionId, (String)namespace));
        }
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(installRequest);
        }
        if ((currentUserReference = this.documentAccessBridge.getCurrentUserReference()) != null) {
            installRequest.setExtensionProperty("user.reference", (Object)currentUserReference.toString());
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("install", (Request)installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public InstallRequest createInstallPlanRequest(String id, String version, String namespace) {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONPLAN_JOBID_PREFIX, (String)id, (String)namespace));
        installRequest.setInteractive(true);
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        installRequest.setRootModificationsAllowed(namespace == null || xcontext.isMainWiki(this.toWikiId(namespace)));
        installRequest.setRewriter((ExtensionRewriter)new ScriptExtensionRewriter());
        this.contextualize((AbstractRequest)installRequest);
        this.setRightsProperties(installRequest);
        return installRequest;
    }

    public Job createInstallPlan(InstallRequest installRequest) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(installRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("installplan", (Request)installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job createInstallPlan(String id, String version, String namespace) {
        return this.createInstallPlan(this.createInstallPlanRequest(id, version, namespace));
    }

    public Job uninstall(String id, String namespace) {
        return this.uninstall(this.createUninstallRequest(id, namespace));
    }

    public Job uninstall(ExtensionId extensionId) {
        return this.uninstall(this.createUninstallRequest(extensionId, null));
    }

    public Job uninstall(UninstallRequest uninstallRequest) {
        this.setError(null);
        if (uninstallRequest.getId() == null || uninstallRequest.getId().size() > 2 && ((String)uninstallRequest.getId().get(1)).equals(EXTENSIONPLAN_JOBID_PREFIX)) {
            String extensionId = ((ExtensionId)uninstallRequest.getExtensions().iterator().next()).getId();
            String namespace = uninstallRequest.getNamespaces() == null ? null : (String)uninstallRequest.getNamespaces().iterator().next();
            uninstallRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONACTION_JOBID_PREFIX, (String)extensionId, (String)namespace));
        }
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(uninstallRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("uninstall", (Request)uninstallRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public UninstallRequest createUninstallRequest(String id, String namespace) {
        return this.createUninstallRequest(new ExtensionId(id, (Version)null), namespace);
    }

    private UninstallRequest createUninstallRequest(ExtensionId extensionId, String namespace) {
        UninstallRequest uninstallRequest = this.createUninstallPlanRequest(extensionId, namespace);
        uninstallRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONACTION_JOBID_PREFIX, (String)extensionId.getId(), (String)namespace));
        return uninstallRequest;
    }

    private UninstallRequest createUninstallPlanRequest(ExtensionId extensionId, String namespace) {
        UninstallRequest uninstallRequest = this.createUninstallRequest();
        uninstallRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONPLAN_JOBID_PREFIX, (String)extensionId.getId(), (String)namespace));
        uninstallRequest.setInteractive(true);
        uninstallRequest.addExtension(extensionId);
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            uninstallRequest.addNamespace(namespace);
        }
        uninstallRequest.setRootModificationsAllowed(namespace == null || ((XWikiContext)this.xcontextProvider.get()).isMainWiki(this.toWikiId(namespace)));
        return uninstallRequest;
    }

    @Unstable
    public UninstallRequest createUninstallRequest() {
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.setInteractive(true);
        this.contextualize((AbstractRequest)uninstallRequest);
        this.setRightsProperties(uninstallRequest);
        return uninstallRequest;
    }

    public Job createUninstallPlan(String id, String namespace) {
        return this.createUninstallPlan(this.createUninstallPlanRequest(new ExtensionId(id, (Version)null), namespace));
    }

    public Job createUninstallPlan(ExtensionId extensionId) {
        return this.createUninstallPlan(this.createUninstallPlanRequest(extensionId, null));
    }

    @Unstable
    public Job createUninstallPlan(UninstallRequest uninstallRequest) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setRightsProperties(uninstallRequest);
        }
        Job job = null;
        try {
            job = this.jobExecutor.execute("uninstallplan", (Request)uninstallRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public InstallRequest createUpgradePlanRequest(String namespace) {
        return this.createUpgradePlanRequest(null, namespace);
    }

    private InstallRequest createUpgradePlanRequest() {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(ExtensionRequest.getJobId((String)EXTENSIONPLAN_JOBID_PREFIX, null, null));
        this.contextualize((AbstractRequest)installRequest);
        return installRequest;
    }

    public InstallRequest createUpgradePlanRequest(ExtensionId extensionId, String namespace) {
        List jobId;
        InstallRequest installRequest = new InstallRequest();
        installRequest.addNamespace(namespace);
        if (extensionId != null) {
            installRequest.addExtension(extensionId);
            jobId = ExtensionRequest.getJobId((String)EXTENSIONPLAN_JOBID_PREFIX, (String)extensionId.getId(), (String)namespace);
        } else {
            jobId = ExtensionRequest.getJobId((String)EXTENSIONPLAN_JOBID_PREFIX, null, (String)namespace);
        }
        installRequest.setId(jobId);
        this.contextualize((AbstractRequest)installRequest);
        return installRequest;
    }

    public Job createUpgradePlan(InstallRequest request) {
        request.setProperty("checkrights", (Object)true);
        request.setProperty("checkUserRights", (Object)true);
        request.setProperty("user.reference", (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            request.setProperty("checkAuthorRights", (Object)true);
            request.setProperty("caller.reference", (Object)callerDocument.getContentAuthorReference());
        }
        Job job = null;
        try {
            job = (Job)this.safe(this.jobExecutor.execute("upgradeplan", (Request)request));
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job createUpgradePlan(String namespace) {
        this.setError(null);
        return this.createUpgradePlan(this.createUpgradePlanRequest(namespace));
    }

    public Job createUpgradePlan() {
        this.setError(null);
        return this.createUpgradePlan(this.createUpgradePlanRequest());
    }

    public Job getCurrentJob() {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            this.setError((Exception)((Object)new JobException("You need programming rights to get the current job.")));
            return null;
        }
        return this.getCurrentJobInternal();
    }

    private Job getCurrentJobInternal() {
        Job job = this.jobExecutor.getCurrentJob(new JobGroupPath(this.fromWikitoNamespace(((XWikiContext)this.xcontextProvider.get()).getWikiId()), AbstractExtensionJob.ROOT_GROUP));
        if (job == null) {
            job = this.jobExecutor.getCurrentJob(AbstractExtensionJob.ROOT_GROUP);
        }
        return job;
    }

    public JobStatus getExtensionJobStatus(String extensionId, String namespace) {
        return this.getJobStatus(ExtensionRequest.getJobId((String)EXTENSIONACTION_JOBID_PREFIX, (String)extensionId, (String)namespace));
    }

    public JobStatus getExtensionPlanJobStatus(String extensionId, String namespace) {
        return this.getJobStatus(ExtensionRequest.getJobId((String)EXTENSIONPLAN_JOBID_PREFIX, (String)extensionId, (String)namespace));
    }

    public JobStatus getCurrentJobStatus() {
        JobStatus jobStatus;
        Job job = this.getCurrentJobInternal();
        if (job != null) {
            jobStatus = job.getStatus();
            if (!this.authorization.hasAccess(Right.PROGRAM)) {
                jobStatus = (JobStatus)this.safe(jobStatus);
            }
        } else {
            jobStatus = null;
        }
        return jobStatus;
    }

    public Version parseVersion(String version) {
        return new DefaultVersion(version);
    }

    public VersionRange parseVersionRange(String versionRange) {
        this.setError(null);
        try {
            return new DefaultVersionRange(versionRange);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public VersionConstraint parseVersionConstraint(String versionConstraint) {
        this.setError(null);
        try {
            return this.factory.getVersionConstraint(versionConstraint);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public ExtensionDependency createExtensionDependency(String id, String versionConstraint) {
        return this.createExtensionDependency(id, versionConstraint, false);
    }

    public ExtensionDependency createExtensionDependency(String id, String versionConstraint, boolean optional) {
        this.setError(null);
        try {
            return this.factory.getExtensionDependency(id, this.factory.getVersionConstraint(versionConstraint), optional, null);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public boolean isAllowed(Collection<String> allowedNamespaces, String namespace) {
        return this.namespaceResolver.isAllowed(allowedNamespaces, namespace);
    }

    public boolean isAllowed(Extension extension, String namespace) {
        return this.namespaceResolver.isAllowed(extension.getAllowedNamespaces(), namespace);
    }

    @Deprecated
    public Collection<InstalledExtension> getInstalledExtensions() {
        return ((InstalledExtensionScriptService)this.get("installed")).getInstalledExtensions();
    }

    @Deprecated
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        return ((InstalledExtensionScriptService)this.get("installed")).getInstalledExtensions(namespace);
    }

    @Deprecated
    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        return ((InstalledExtensionScriptService)this.get("installed")).getInstalledExtension(feature, namespace);
    }

    @Deprecated
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(String feature, String version) {
        return ((InstalledExtensionScriptService)this.get("installed")).getBackwardDependencies(feature);
    }

    @Deprecated
    public Collection<CoreExtension> getCoreExtensions() {
        return ((CoreExtensionScriptService)this.get("core")).getCoreExtensions();
    }

    @Deprecated
    public CoreExtension getCoreExtension(String feature) {
        return ((CoreExtensionScriptService)this.get("core")).getCoreExtension(feature);
    }

    @Deprecated
    public Collection<LocalExtension> getLocalExtensions() {
        return ((LocalExtensionScriptService)this.get("local")).getLocalExtensions();
    }

    public Extension getAccessibleExtension(String feature, Namespace namespace) {
        return this.extensionManager.getAccessibleExtension(feature, namespace);
    }

    public IterableResult<Extension> searchAccessibleExtensions(Namespace namespace, ExtensionQuery query) throws SearchException {
        return this.extensionManager.searchAccessibleExtensions(namespace, query);
    }
}

