/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.context.Execution;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.script.JobScriptService;
import org.xwiki.script.internal.safe.ScriptSafeProvider;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.stability.Unstable;

public abstract class AbstractExtensionScriptService
implements ScriptService {
    public static final String EXTENSIONERROR_KEY = "scriptservice.extension.error";
    protected static final String PROPERTY_CONTEXT_WIKI = "context.wiki";
    protected static final String PROPERTY_CONTEXT_ACTION = "context.action";
    protected static final String PROPERTY_USERREFERENCE = "user.reference";
    protected static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    protected static final String PROPERTY_CHECKRIGHTS = "checkrights";
    protected static final String WIKI_NAMESPACE_PREFIX = "wiki:";
    @Inject
    protected ScriptSafeProvider scriptProvider;
    @Inject
    protected Execution execution;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected JobExecutor jobExecutor;
    @Inject
    protected ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="job")
    private ScriptService jobScriptService;

    protected <S> S safe(Object unsafe) {
        return (S)this.scriptProvider.get(unsafe);
    }

    protected <T extends AbstractRequest> void setRightsProperties(T extensionRequest) {
        extensionRequest.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        extensionRequest.setProperty("checkUserRights", (Object)true);
        extensionRequest.setProperty(PROPERTY_USERREFERENCE, (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            extensionRequest.setProperty("checkAuthorRights", (Object)true);
            extensionRequest.setProperty(PROPERTY_CALLERREFERENCE, (Object)callerDocument.getContentAuthorReference());
        }
    }

    protected XWikiDocument getCallerDocument() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument sdoc = (XWikiDocument)xcontext.get((Object)"sdoc");
        if (sdoc == null) {
            sdoc = xcontext.getDoc();
        }
        return sdoc;
    }

    protected JobStatus getJobStatus(List<String> jobId) {
        return ((JobScriptService)this.jobScriptService).getJobStatus(jobId);
    }

    protected String toWikiId(String namespace) {
        if (namespace != null && namespace.startsWith(WIKI_NAMESPACE_PREFIX)) {
            return namespace.substring(WIKI_NAMESPACE_PREFIX.length());
        }
        return null;
    }

    protected String fromWikitoNamespace(String wiki) {
        return WIKI_NAMESPACE_PREFIX + wiki;
    }

    public void contextualize(AbstractRequest request) {
        request.setProperty(PROPERTY_CONTEXT_WIKI, (Object)((XWikiContext)this.xcontextProvider.get()).getWikiId());
        request.setProperty(PROPERTY_CONTEXT_ACTION, (Object)((XWikiContext)this.xcontextProvider.get()).getAction());
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(EXTENSIONERROR_KEY);
    }

    protected void setError(Exception e) {
        this.execution.getContext().setProperty(EXTENSIONERROR_KEY, (Object)e);
    }

    @Unstable
    protected <R> R wrapError(Callable<R> callable) {
        this.setError(null);
        try {
            return callable.call();
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    @Unstable
    protected <R> R safeWrapError(Callable<R> callable) {
        return (R)this.wrapError(() -> this.safe(callable.call()));
    }
}

