/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.rating.ExtensionRating;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.rating.Ratable;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.extension.version.Version;

@Component
@Named(value="extension.rating")
@Singleton
public class ExtensionRatingScriptService
extends AbstractExtensionScriptService {
    public static final String ID = "rating";
    @Inject
    private ExtensionRepositoryManager repositoryManager;

    private Collection<ExtensionRepository> getRepositories() {
        return this.repositoryManager.getRepositories();
    }

    public ExtensionRating getRating(ExtensionId extensionId) {
        this.setError(null);
        try {
            return this.getRating(extensionId.getId(), extensionId.getVersion());
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public ExtensionRating getRating(String extensionId, Version extensionVersion) {
        this.setError(null);
        try {
            return this.getRating(extensionId, extensionVersion.getValue());
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public ExtensionRating getRating(String extensionId, String extensionVersion) {
        this.setError(null);
        Collection<ExtensionRepository> repositories = this.getRepositories();
        for (ExtensionRepository repository : repositories) {
            if (!(repository instanceof Ratable)) continue;
            try {
                this.setError(null);
                return ((Ratable)repository).getRating(extensionId, extensionVersion);
            }
            catch (ResolveException e) {
                this.setError((Exception)((Object)e));
            }
        }
        return null;
    }
}

