/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal.safe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.script.internal.safe.SafeExtensionPlanAction;
import org.xwiki.extension.script.internal.safe.SafeExtensionPlanNode;
import org.xwiki.extension.script.internal.safe.SafeJobStatus;

public class SafeExtensionPlan
extends SafeJobStatus<ExtensionPlan>
implements ExtensionPlan {
    private Collection<ExtensionPlanNode> wrappedTree;
    private Collection<ExtensionPlanAction> wrappedActions;

    public SafeExtensionPlan(ExtensionPlan plan, ScriptSafeProvider<?> safeProvider) {
        super(plan, safeProvider);
    }

    public Collection<ExtensionPlanNode> getTree() {
        if (this.wrappedTree == null) {
            Collection nodes = ((ExtensionPlan)this.getWrapped()).getTree();
            if (nodes.isEmpty()) {
                this.wrappedTree = Collections.emptyList();
            } else {
                this.wrappedTree = new ArrayList<ExtensionPlanNode>(nodes.size());
                for (ExtensionPlanNode node : nodes) {
                    this.wrappedTree.add(new SafeExtensionPlanNode(node, this.safeProvider));
                }
            }
        }
        return this.wrappedTree;
    }

    public Collection<ExtensionPlanAction> getActions() {
        if (this.wrappedActions == null) {
            Collection actions = ((ExtensionPlan)this.getWrapped()).getActions();
            if (actions.isEmpty()) {
                this.wrappedActions = Collections.emptyList();
            } else {
                this.wrappedActions = new ArrayList<ExtensionPlanAction>(actions.size());
                for (ExtensionPlanAction action : actions) {
                    this.wrappedActions.add(new SafeExtensionPlanAction(action, (ScriptSafeProvider<Object>)this.safeProvider));
                }
            }
        }
        return this.wrappedActions;
    }
}

