/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionRange;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="extension")
@Singleton
public class ExtensionManagerScriptService
implements ScriptService {
    public static final String EXTENSIONERROR_KEY = "scriptservice.extension.error";
    public static final String EXTENSION_JOBID_PREFIX = "extension";
    public static final String EXTENSIONACTION_JOBID_PREFIX = "action";
    public static final String EXTENSIONPLAN_JOBID_PREFIX = "plan";
    private static final String PROPERTY_USERREFERENCE = "user.reference";
    private static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    private static final String PROPERTY_CHECKRIGHTS = "checkrights";
    private static final String PROPERTY_JOB_TYPE = "job.type";
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private JobManager jobManager;
    @Inject
    private Execution execution;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ScriptSafeProvider scriptProvider;

    private <T> T safe(T unsafe) {
        return (T)this.scriptProvider.get(unsafe);
    }

    public Collection<ExtensionRepository> getRepositories() {
        return this.safe(this.repositoryManager.getRepositories());
    }

    public ExtensionRepository getRepository(String repositoryId) {
        return this.safe(this.extensionManager.getRepository(repositoryId));
    }

    public IterableResult<Extension> search(String pattern, int offset, int nb) {
        return this.repositoryManager.search(pattern, offset, nb);
    }

    public Extension resolve(String id, String version) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = this.safe(this.extensionManager.resolveExtension(new ExtensionId(id, version)));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    public Extension resolve(ExtensionDependency extensionDependency) {
        this.setError(null);
        Extension extension = null;
        try {
            extension = this.safe(this.extensionManager.resolveExtension(extensionDependency));
        }
        catch (Exception e) {
            this.setError(e);
        }
        return extension;
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        this.setError(null);
        IterableResult versions = null;
        try {
            versions = this.repositoryManager.resolveVersions(id, offset, nb);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return versions;
    }

    public Collection<InstalledExtension> getInstalledExtensions() {
        return this.safe(this.installedExtensionRepository.getInstalledExtensions());
    }

    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        return this.safe(this.installedExtensionRepository.getInstalledExtensions(namespace));
    }

    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        return this.safe(this.installedExtensionRepository.getInstalledExtension(feature, namespace));
    }

    public Collection<CoreExtension> getCoreExtensions() {
        return this.safe(this.coreExtensionRepository.getCoreExtensions());
    }

    public CoreExtension getCoreExtension(String feature) {
        return this.safe(this.coreExtensionRepository.getCoreExtension(feature));
    }

    public Collection<LocalExtension> getLocalExtensions() {
        return this.safe(this.localExtensionRepository.getLocalExtensions());
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(String feature, String version) {
        Map extensions;
        this.setError(null);
        try {
            extensions = this.safe(this.installedExtensionRepository.getBackwardDependencies(new ExtensionId(feature, version)));
        }
        catch (Exception e) {
            this.setError(e);
            extensions = null;
        }
        return extensions;
    }

    private XWikiDocument getCallerDocument() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument sdoc = (XWikiDocument)xcontext.get((Object)"sdoc");
        if (sdoc == null) {
            sdoc = xcontext.getDoc();
        }
        return sdoc;
    }

    private List<String> getJobId(String prefix, String extensionId, String namespace) {
        List<String> jobId = namespace != null ? Arrays.asList(EXTENSION_JOBID_PREFIX, prefix, extensionId, namespace) : Arrays.asList(EXTENSION_JOBID_PREFIX, prefix, extensionId);
        return jobId;
    }

    public InstallRequest createInstallRequest(String id, String version, String namespace) {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONACTION_JOBID_PREFIX, id, namespace));
        installRequest.setInteractive(true);
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        installRequest.setProperty(PROPERTY_USERREFERENCE, (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            installRequest.setProperty(PROPERTY_CALLERREFERENCE, (Object)callerDocument.getContentAuthorReference());
        }
        installRequest.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        return installRequest;
    }

    public Job install(String id, String version, String namespace) {
        return this.install(this.createInstallRequest(id, version, namespace));
    }

    public Job install(InstallRequest installRequest) {
        this.setError(null);
        if (installRequest.getProperty(PROPERTY_CHECKRIGHTS) != Boolean.TRUE && !this.documentAccessBridge.hasProgrammingRights()) {
            installRequest.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        }
        Job job = null;
        try {
            job = this.jobManager.addJob("install", (Request)installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job createInstallPlan(String id, String version, String namespace) {
        this.setError(null);
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, id, namespace));
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        installRequest.setProperty(PROPERTY_USERREFERENCE, (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            installRequest.setProperty(PROPERTY_CALLERREFERENCE, (Object)callerDocument.getContentAuthorReference());
        }
        installRequest.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        installRequest.setProperty(PROPERTY_JOB_TYPE, (Object)"installplan");
        Job job = null;
        try {
            job = this.jobManager.addJob("installplan", (Request)installRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job uninstall(String id, String namespace) {
        return this.uninstall(new ExtensionId(id, (Version)null), namespace);
    }

    public Job uninstall(ExtensionId extensionId) {
        return this.uninstall(extensionId, null);
    }

    private Job uninstall(ExtensionId extensionId, String namespace) {
        this.setError(null);
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.setId(this.getJobId(EXTENSIONACTION_JOBID_PREFIX, extensionId.getId(), namespace));
        uninstallRequest.addExtension(extensionId);
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            uninstallRequest.addNamespace(namespace);
        }
        uninstallRequest.setProperty(PROPERTY_USERREFERENCE, (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            uninstallRequest.setProperty(PROPERTY_CALLERREFERENCE, (Object)callerDocument.getContentAuthorReference());
        }
        uninstallRequest.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        Job job = null;
        try {
            job = this.jobManager.addJob("uninstall", (Request)uninstallRequest);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return job;
    }

    public Job createUninstallPlan(String id, String namespace) {
        return this.createUninstallPlan(new ExtensionId(id, (Version)null), namespace);
    }

    public Job createUninstallPlan(ExtensionId extensionId) {
        return this.createUninstallPlan(extensionId, null);
    }

    private Job createUninstallPlan(ExtensionId extensionId, String namespace) {
        this.setError(null);
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, extensionId.getId(), namespace));
        uninstallRequest.addExtension(extensionId);
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            uninstallRequest.addNamespace(namespace);
        }
        uninstallRequest.setProperty(PROPERTY_USERREFERENCE, (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            uninstallRequest.setProperty(PROPERTY_CALLERREFERENCE, (Object)callerDocument.getContentAuthorReference());
        }
        uninstallRequest.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        uninstallRequest.setProperty(PROPERTY_JOB_TYPE, (Object)"uninstallplan");
        Job job = null;
        try {
            job = this.jobManager.executeJob("uninstallplan", (Request)uninstallRequest);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    private InstallRequest createUpgradePlanRequest(String namespace) {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, null, namespace));
        installRequest.addNamespace(namespace);
        return installRequest;
    }

    private InstallRequest createUpgradePlanRequest() {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, null, null));
        return installRequest;
    }

    public Job createUpgradePlan(InstallRequest request) {
        request.setProperty(PROPERTY_USERREFERENCE, (Object)this.documentAccessBridge.getCurrentUserReference());
        XWikiDocument callerDocument = this.getCallerDocument();
        if (callerDocument != null) {
            request.setProperty(PROPERTY_CALLERREFERENCE, (Object)callerDocument.getContentAuthorReference());
        }
        request.setProperty(PROPERTY_CHECKRIGHTS, (Object)true);
        Job job = null;
        try {
            job = this.safe(this.jobManager.addJob("upgradeplan", (Request)request));
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
        }
        return job;
    }

    public Job createUpgradePlan(String namespace) {
        this.setError(null);
        return this.createUpgradePlan(this.createUpgradePlanRequest(namespace));
    }

    public Job createUpgradePlan() {
        this.setError(null);
        return this.createUpgradePlan(this.createUpgradePlanRequest());
    }

    public Job getCurrentJob() {
        this.setError(null);
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            this.setError((Exception)((Object)new JobException("Need programming right to get current job")));
            return null;
        }
        return this.jobManager.getCurrentJob();
    }

    private JobStatus getJobStatus(List<String> jobId) {
        JobStatus jobStatus = this.jobManager.getJobStatus(jobId);
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            jobStatus = this.safe(jobStatus);
        }
        return jobStatus;
    }

    public JobStatus getExtensionJobStatus(String extensionId, String namespace) {
        return this.getJobStatus(this.getJobId(EXTENSIONACTION_JOBID_PREFIX, extensionId, namespace));
    }

    public JobStatus getExtensionPlanJobStatus(String extensionId, String namespace) {
        return this.getJobStatus(this.getJobId(EXTENSIONPLAN_JOBID_PREFIX, extensionId, namespace));
    }

    public JobStatus getCurrentJobStatus() {
        JobStatus jobStatus;
        Job job = this.jobManager.getCurrentJob();
        if (job != null) {
            jobStatus = job.getStatus();
            if (!this.documentAccessBridge.hasProgrammingRights()) {
                jobStatus = this.safe(jobStatus);
            }
        } else {
            jobStatus = null;
        }
        return jobStatus;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(EXTENSIONERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(EXTENSIONERROR_KEY, (Object)e);
    }

    public Version parseVersion(String version) {
        return new DefaultVersion(version);
    }

    public VersionRange parseVersionRange(String versionRange) {
        this.setError(null);
        try {
            return new DefaultVersionRange(versionRange);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public VersionConstraint parseVersionConstraint(String versionConstraint) {
        this.setError(null);
        try {
            return new DefaultVersionConstraint(versionConstraint);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public ExtensionDependency createExtensionDependency(String id, String versionConstraint) {
        this.setError(null);
        try {
            return new DefaultExtensionDependency(id, (VersionConstraint)new DefaultVersionConstraint(versionConstraint));
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }
}

