/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionValidator;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class XWikiExtensionValidator
implements ExtensionValidator {
    private static final String PROPERTY_USERREFERENCE = "user.reference";
    private static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    private static final String PROPERTY_CHECKRIGHTS = "checkrights";
    private static final String XWIKIPREFERENCES_FULLNAME = "XWiki.XWikiPreferences";
    private static final String RIGHTS_PROGRAMMING = "programming";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    private boolean hasAccessLevel(String right, String document, Request request) throws XWikiException {
        String user;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        boolean hasAccess = true;
        String caller = this.getRequestUserString(PROPERTY_CALLERREFERENCE, request);
        if (caller != null) {
            hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, caller, XWIKIPREFERENCES_FULLNAME, xcontext);
        }
        if (hasAccess && (user = this.getRequestUserString(PROPERTY_USERREFERENCE, request)) != null) {
            hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, user, XWIKIPREFERENCES_FULLNAME, xcontext);
        }
        return hasAccess;
    }

    private DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    private String getRequestUserString(String property, Request request) {
        String str = null;
        if (request.containsProperty(property)) {
            DocumentReference reference = this.getRequestUserReference(property, request);
            str = reference != null ? (String)this.serializer.serialize((EntityReference)reference, new Object[0]) : "XWiki.XWikiGuest";
        }
        return str;
    }

    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(RIGHTS_PROGRAMMING, namespace + XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new InstallException(String.format("Programming right is required to install extension [%s]", extension.getId()));
                    }
                    throw new InstallException(String.format("Programming right is required to install extension [%s] on namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new InstallException("Failed to check rights to install extension", (Throwable)e);
            }
        }
    }

    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(RIGHTS_PROGRAMMING, namespace + XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new UninstallException(String.format("Programming right is required to uninstall extension [%s]", extension.getId()));
                    }
                    throw new UninstallException(String.format("Programming right is required to uninstall extension [%s] from namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new UninstallException("Failed to check rights to uninstall extension", (Throwable)e);
            }
        }
    }
}

