/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.versioncheck.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.versioncheck.internal.EnvironmentVersionCheckTimer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;

@Singleton
@Component
@Named(value="VersionCheckInitializer")
public class VersionCheckInitializer
extends AbstractEventListener {
    static final String LISTENER_NAME = "VersionCheckInitializer";
    @Inject
    private EnvironmentVersionCheckTimer environmentVersionCheckTimer;
    @Inject
    private Logger logger;

    public VersionCheckInitializer() {
        super(LISTENER_NAME, new Event[]{new ApplicationStartedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ApplicationStartedEvent) {
            try {
                this.environmentVersionCheckTimer.initialize();
            }
            catch (InitializationException e) {
                this.logger.warn("Failed to initialize timer for checking new environment versions: [{}]", (Throwable)e);
            }
        }
    }
}

