/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.feed;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.feed.SyndEntrySource;
import com.xpn.xwiki.util.TidyMessageLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.output.NullWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessageListener;
import org.xwiki.xml.XMLUtils;

public class SyndEntryDocumentSource
implements SyndEntrySource {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SyndEntryDocumentSource.class);
    protected static final TidyMessageLogger TIDY_LOGGER = new TidyMessageLogger(LOGGER);
    public static final String CONTENT_TYPE = "ContentType";
    public static final String CONTENT_LENGTH = "ContentLength";
    public static final Properties TIDY_FEED_CONFIG = new Properties();
    public static final Properties TIDY_XML_CONFIG;
    public static final Properties TIDY_HTML_CONFIG;
    public static final String FIELD_URI = "uri";
    public static final String FIELD_LINK = "link";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_CATEGORIES = "categories";
    public static final String FIELD_PUBLISHED_DATE = "publishedDate";
    public static final String FIELD_UPDATED_DATE = "updatedDate";
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_CONTRIBUTORS = "contributors";
    public static final Map<String, Object> DEFAULT_PARAMS;
    private Map<String, Object> params;

    public SyndEntryDocumentSource() {
        this(new HashMap<String, Object>());
    }

    public SyndEntryDocumentSource(Map<String, Object> params) {
        this.setParams(params);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = this.joinParams(params, this.getDefaultParams());
    }

    protected Map<String, Object> getDefaultParams() {
        return DEFAULT_PARAMS;
    }

    @Override
    public void source(SyndEntry entry, Object obj, Map<String, Object> params, XWikiContext context) throws XWikiException {
        Document doc = this.castDocument(obj, context);
        if (!doc.hasAccessLevel("view")) {
            throw new XWikiException(9, 9001, "Access denied in view mode!");
        }
        Map<String, Object> trueParams = this.joinParams(params, this.getParams());
        this.sourceDocument(entry, doc, trueParams, context);
    }

    public void sourceDocument(SyndEntry entry, Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        entry.setUri(this.getURI(doc, params, context));
        entry.setLink(this.getLink(doc, params, context));
        entry.setTitle(this.getTitle(doc, params, context));
        entry.setDescription(this.getDescription(doc, params, context));
        entry.setCategories(this.getCategories(doc, params, context));
        entry.setPublishedDate(this.getPublishedDate(doc, params, context));
        entry.setUpdatedDate(this.getUpdateDate(doc, params, context));
        entry.setAuthor(this.getAuthor(doc, params, context));
        entry.setContributors(this.getContributors(doc, params, context));
    }

    protected String getDefaultURI(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        return doc.getExternalURL("view", "language=" + doc.getRealLanguage());
    }

    protected String getURI(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_URI);
        if (mapping == null) {
            return this.getDefaultURI(doc, params, context);
        }
        if (this.isVelocityCode(mapping)) {
            return this.parseString(mapping, doc, context);
        }
        return this.getStringValue(mapping, doc, context);
    }

    protected String getDefaultLink(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        return this.getDefaultURI(doc, params, context);
    }

    protected String getLink(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_LINK);
        if (mapping == null) {
            return this.getDefaultLink(doc, params, context);
        }
        if (this.isVelocityCode(mapping)) {
            return this.parseString(mapping, doc, context);
        }
        return this.getStringValue(mapping, doc, context);
    }

    protected String getDefaultTitle(Document doc, Map<String, Object> params, XWikiContext context) {
        return doc.getDisplayTitle();
    }

    protected String getTitle(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_TITLE);
        if (mapping == null) {
            return this.getDefaultTitle(doc, params, context);
        }
        if (this.isVelocityCode(mapping)) {
            return this.parseString(mapping, doc, context);
        }
        return this.getStringValue(mapping, doc, context);
    }

    protected String getDefaultDescription(Document doc, Map<String, Object> params, XWikiContext context) {
        XWiki xwiki = context.getWiki();
        String author = xwiki.getUserName(doc.getAuthor(), null, false, context);
        String descFormat = "Version %1$s edited by %2$s on %3$s";
        return String.format(descFormat, doc.getVersion(), author, doc.getDate());
    }

    protected SyndContent getDescription(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_DESCRIPTION);
        String description = mapping == null ? this.getDefaultDescription(doc, params, context) : (this.isVelocityCode(mapping) ? this.parseString(mapping, doc, context) : doc.getRenderedContent(this.getStringValue(mapping, doc, context), doc.getSyntaxId()));
        String contentType = (String)params.get(CONTENT_TYPE);
        int contentLength = ((Number)params.get(CONTENT_LENGTH)).intValue();
        if (contentLength >= 0) {
            if ("text/plain".equals(contentType)) {
                description = SyndEntryDocumentSource.getPlainPreview(description, contentLength);
            } else if ("text/html".equals(contentType)) {
                description = SyndEntryDocumentSource.getHTMLPreview(description, contentLength);
            } else if ("text/xml".equals(contentType)) {
                description = SyndEntryDocumentSource.getXMLPreview(description, contentLength);
            }
        }
        return this.getSyndContent(contentType, description);
    }

    protected List<SyndCategory> getDefaultCategories(Document doc, Map<String, Object> params, XWikiContext context) {
        return Collections.emptyList();
    }

    protected List<SyndCategory> getCategories(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_CATEGORIES);
        if (mapping == null) {
            return this.getDefaultCategories(doc, params, context);
        }
        List<Object> categories = this.isVelocityCode(mapping) ? this.parseList(mapping, doc, context) : this.getListValue(mapping, doc, context);
        ArrayList<SyndCategory> result = new ArrayList<SyndCategory>();
        for (Object category : categories) {
            if (category instanceof SyndCategory) {
                result.add((SyndCategory)category);
                continue;
            }
            if (category == null) continue;
            SyndCategoryImpl scat = new SyndCategoryImpl();
            scat.setName(category.toString());
            result.add((SyndCategory)scat);
        }
        return result;
    }

    protected Date getDefaultPublishedDate(Document doc, Map<String, Object> params, XWikiContext context) {
        return doc.getDate();
    }

    protected Date getPublishedDate(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_PUBLISHED_DATE);
        if (mapping == null) {
            return this.getDefaultPublishedDate(doc, params, context);
        }
        if (this.isVelocityCode(mapping)) {
            return this.parseDate(mapping, doc, context);
        }
        return this.getDateValue(mapping, doc, context);
    }

    protected Date getDefaultUpdateDate(Document doc, Map<String, Object> params, XWikiContext context) {
        return doc.getDate();
    }

    protected Date getUpdateDate(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_UPDATED_DATE);
        if (mapping == null) {
            return this.getDefaultUpdateDate(doc, params, context);
        }
        if (this.isVelocityCode(mapping)) {
            return this.parseDate(mapping, doc, context);
        }
        return this.getDateValue(mapping, doc, context);
    }

    protected String getDefaultAuthor(Document doc, Map<String, Object> params, XWikiContext context) {
        return context.getWiki().getUserName(doc.getCreator(), null, false, context);
    }

    protected String getAuthor(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_AUTHOR);
        if (mapping == null) {
            return this.getDefaultAuthor(doc, params, context);
        }
        if (this.isVelocityCode(mapping)) {
            return this.parseString(mapping, doc, context);
        }
        return this.getStringValue(mapping, doc, context);
    }

    protected List<String> getDefaultContributors(Document doc, Map<String, Object> params, XWikiContext context) {
        XWiki xwiki = context.getWiki();
        ArrayList<String> contributors = new ArrayList<String>();
        contributors.add(xwiki.getUserName(doc.getAuthor(), null, false, context));
        return contributors;
    }

    protected List<String> getContributors(Document doc, Map<String, Object> params, XWikiContext context) throws XWikiException {
        String mapping = (String)params.get(FIELD_CONTRIBUTORS);
        if (mapping == null) {
            return this.getDefaultContributors(doc, params, context);
        }
        List<Object> rawContributors = this.isVelocityCode(mapping) ? this.parseList(mapping, doc, context) : this.getListValue(mapping, doc, context);
        ArrayList<String> contributors = new ArrayList<String>();
        for (Object rawContributor : rawContributors) {
            if (rawContributor instanceof String) {
                contributors.add((String)rawContributor);
                continue;
            }
            contributors.add(rawContributor.toString());
        }
        return contributors;
    }

    protected boolean isVelocityCode(String mapping) {
        return mapping.charAt(0) == '{' && mapping.charAt(mapping.length() - 1) == '}';
    }

    protected String parseString(String mapping, Document doc, XWikiContext context) throws XWikiException {
        if (this.isVelocityCode(mapping)) {
            return doc.getRenderedContent(mapping.substring(1, mapping.length() - 1), doc.getSyntax().toIdString());
        }
        return mapping;
    }

    protected Date parseDate(String mapping, Document doc, XWikiContext context) throws NumberFormatException, XWikiException {
        if (this.isVelocityCode(mapping)) {
            return new Date(Long.parseLong(this.parseString(mapping, doc, context).trim()));
        }
        return null;
    }

    protected List<Object> parseList(String mapping, Document doc, XWikiContext context) throws XWikiException {
        if (!this.isVelocityCode(mapping)) {
            return null;
        }
        String strRep = this.parseString(mapping, doc, context).trim();
        if (strRep.charAt(0) != '[' || strRep.charAt(strRep.length() - 1) != ']') {
            return null;
        }
        String[] array = strRep.substring(1, strRep.length() - 1).split(",");
        if (array.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected String getStringValue(String mapping, Document doc, XWikiContext context) throws XWikiException {
        PropertySelector ps = new PropertySelector(mapping);
        if (ps.getClassName() == null) {
            return doc.display(ps.getPropertyName());
        }
        XWikiDocument xdoc = context.getWiki().getDocument(doc.getFullName(), context);
        return xdoc.getObject(ps.getClassName(), ps.getObjectIndex()).getStringValue(ps.getPropertyName());
    }

    protected Date getDateValue(String mapping, Document doc, XWikiContext context) throws XWikiException {
        XWikiDocument xdoc = context.getWiki().getDocument(doc.getFullName(), context);
        PropertySelector ps = new PropertySelector(mapping);
        if (ps.getClassName() == null) {
            return xdoc.getFirstObject(ps.getPropertyName(), context).getDateValue(ps.getPropertyName());
        }
        return xdoc.getObject(ps.getClassName(), ps.getObjectIndex()).getDateValue(ps.getPropertyName());
    }

    protected List<Object> getListValue(String mapping, Document doc, XWikiContext context) throws XWikiException {
        XWikiDocument xdoc = context.getWiki().getDocument(doc.getFullName(), context);
        PropertySelector ps = new PropertySelector(mapping);
        if (ps.getClassName() == null) {
            return xdoc.getFirstObject(ps.getPropertyName(), context).getListValue(ps.getPropertyName());
        }
        return xdoc.getObject(ps.getClassName(), ps.getObjectIndex()).getListValue(ps.getPropertyName());
    }

    protected Map<String, Object> joinParams(Map<String, Object> base, Map<String, Object> extra) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(base);
        for (Map.Entry<String, Object> entry : extra.entrySet()) {
            if (params.get(entry.getKey()) != null) continue;
            params.put(entry.getKey(), entry.getValue());
        }
        return params;
    }

    public static org.w3c.dom.Document tidy(String xmlFragment, Properties config) {
        Tidy tidy = new Tidy();
        tidy.setConfigurationFromProps(config);
        tidy.setMessageListener((TidyMessageListener)TIDY_LOGGER);
        tidy.setErrout(new PrintWriter((Writer)new NullWriter()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(xmlFragment.getBytes(Charset.forName(config.getProperty("input-encoding"))));
        return tidy.parseDOM((InputStream)in, (OutputStream)out);
    }

    public static int innerTextLength(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                return node.getNodeValue().length();
            }
            case 1: {
                int length = 0;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    length += SyndEntryDocumentSource.innerTextLength(child);
                }
                return length;
            }
            case 9: {
                return SyndEntryDocumentSource.innerTextLength(((org.w3c.dom.Document)node).getDocumentElement());
            }
        }
        return 0;
    }

    public static String getXMLPreview(String xmlFragment, int previewLength) {
        try {
            return XMLUtils.extractXML((Node)SyndEntryDocumentSource.tidy(xmlFragment, TIDY_XML_CONFIG), (int)0, (int)previewLength);
        }
        catch (RuntimeException e) {
            return SyndEntryDocumentSource.getPlainPreview(xmlFragment, previewLength);
        }
    }

    public static String getHTMLPreview(String htmlFragment, int previewLength) {
        try {
            org.w3c.dom.Document html = SyndEntryDocumentSource.tidy(htmlFragment, TIDY_HTML_CONFIG);
            Node body = html.getElementsByTagName("body").item(0);
            return XMLUtils.extractXML((Node)body.getFirstChild(), (int)0, (int)previewLength);
        }
        catch (RuntimeException e) {
            return SyndEntryDocumentSource.getPlainPreview(htmlFragment, previewLength);
        }
    }

    public static String getPlainPreview(String plainText, int previewLength) {
        if (plainText.length() <= previewLength) {
            return plainText;
        }
        if ((plainText = plainText.trim()).length() <= previewLength) {
            return plainText;
        }
        int spaceIndex = plainText.lastIndexOf(" ", previewLength);
        if (spaceIndex < 0) {
            spaceIndex = previewLength;
        }
        plainText = plainText.substring(0, spaceIndex);
        return plainText;
    }

    protected SyndContent getSyndContent(String type, String value) {
        SyndContentImpl content = new SyndContentImpl();
        content.setType(type);
        content.setValue(value);
        return content;
    }

    protected Document castDocument(Object obj, XWikiContext context) throws XWikiException {
        if (obj instanceof Document) {
            return (Document)obj;
        }
        if (obj instanceof XWikiDocument) {
            return ((XWikiDocument)obj).newDocument(context);
        }
        if (obj instanceof String) {
            return context.getWiki().getDocument((String)obj, context).newDocument(context);
        }
        throw new XWikiException(5, 2, "");
    }

    static {
        TIDY_FEED_CONFIG.setProperty("force-output", "yes");
        TIDY_FEED_CONFIG.setProperty("indent-attributes", "no");
        TIDY_FEED_CONFIG.setProperty("indent", "no");
        TIDY_FEED_CONFIG.setProperty("quiet", "yes");
        TIDY_FEED_CONFIG.setProperty("trim-empty-elements", "yes");
        TIDY_XML_CONFIG = new Properties(TIDY_FEED_CONFIG);
        TIDY_XML_CONFIG.setProperty("input-xml", "yes");
        TIDY_XML_CONFIG.setProperty("output-xml", "yes");
        TIDY_XML_CONFIG.setProperty("add-xml-pi", "no");
        TIDY_XML_CONFIG.setProperty("input-encoding", "UTF8");
        TIDY_HTML_CONFIG = new Properties(TIDY_FEED_CONFIG);
        TIDY_HTML_CONFIG.setProperty("output-xhtml", "yes");
        TIDY_HTML_CONFIG.setProperty("show-body-only", "yes");
        TIDY_HTML_CONFIG.setProperty("drop-empty-paras", "yes");
        TIDY_HTML_CONFIG.setProperty("enclose-text", "yes");
        TIDY_HTML_CONFIG.setProperty("logical-emphasis", "yes");
        TIDY_HTML_CONFIG.setProperty("input-encoding", "UTF8");
        DEFAULT_PARAMS = new HashMap<String, Object>();
        DEFAULT_PARAMS.put(CONTENT_TYPE, "text/html");
        DEFAULT_PARAMS.put(CONTENT_LENGTH, new Integer(-1));
    }

    public static class PropertySelector {
        private String className;
        private int objectIndex;
        private String propertyName;

        public PropertySelector(String strRep) {
            int indexStartPos = strRep.indexOf(95);
            if (indexStartPos < 0) {
                this.className = null;
                this.objectIndex = 0;
                this.propertyName = strRep;
            } else {
                int propStartPos = strRep.indexOf("_", indexStartPos + 1);
                if (propStartPos < 0) {
                    this.className = strRep.substring(0, indexStartPos);
                    this.objectIndex = 0;
                    this.propertyName = strRep.substring(indexStartPos + 1);
                } else {
                    this.className = strRep.substring(0, indexStartPos);
                    this.objectIndex = Integer.parseInt(strRep.substring(indexStartPos + 1, propStartPos));
                    this.propertyName = strRep.substring(propStartPos + 1);
                }
            }
        }

        public String getClassName() {
            return this.className;
        }

        public int getObjectIndex() {
            return this.objectIndex;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

