/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.feed;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.io.SyndFeedOutput;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.feed.FeedPluginApi;
import com.xpn.xwiki.plugin.feed.SyndEntrySource;
import com.xpn.xwiki.plugin.feed.UpdateThread;
import com.xpn.xwiki.plugin.feed.XWikiFeedFetcher;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.converter.Converter;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

public class FeedPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    private Cache<SyndFeed> feedCache;
    private int refreshPeriod;
    private Map<String, UpdateThread> updateThreads = new HashMap<String, UpdateThread>();
    private Converter syntaxConverter;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedPlugin.class);

    public FeedPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.init(context);
    }

    public String getName() {
        return "feed";
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new FeedPluginApi((FeedPlugin)plugin, context);
    }

    public void flushCache() {
        if (this.feedCache != null) {
            this.feedCache.dispose();
        }
        this.feedCache = null;
    }

    public void init(XWikiContext context) {
        super.init(context);
        this.prepareCache(context);
        this.refreshPeriod = (int)context.getWiki().ParamAsLong("xwiki.plugins.feed.cacherefresh", 3600L);
        try {
            this.getAggregatorURLClass(context);
        }
        catch (XWikiException e) {
            // empty catch block
        }
        try {
            this.getFeedEntryClass(context);
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
    }

    public void initCache(XWikiContext context) throws XWikiException {
        int iCapacity = 100;
        try {
            String capacity = context.getWiki().Param("xwiki.plugins.feed.cache.capacity");
            if (capacity != null) {
                iCapacity = Integer.parseInt(capacity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initCache(iCapacity, context);
    }

    public void initCache(int iCapacity, XWikiContext context) throws XWikiException {
        try {
            CacheConfiguration configuration = new CacheConfiguration();
            configuration.setConfigurationId("xwiki.plugin.feedcache");
            LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
            lru.setMaxEntries(iCapacity);
            lru.setMaxIdle(this.refreshPeriod);
            configuration.put((java.lang.Object)"eviction", (java.lang.Object)lru);
            CacheManager cacheManager = (CacheManager)Utils.getComponent(CacheManager.class);
            this.feedCache = cacheManager.createNewLocalCache(configuration);
        }
        catch (CacheException e) {
            throw new XWikiException(16, 16001, "Failed to create cache");
        }
    }

    protected void prepareCache(XWikiContext context) {
        try {
            if (this.feedCache == null) {
                this.initCache(context);
            }
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
    }

    public SyndFeed getFeeds(String sfeeds, XWikiContext context) throws IOException {
        return this.getFeeds(sfeeds, false, true, context);
    }

    public SyndFeed getFeeds(String sfeeds, boolean force, XWikiContext context) throws IOException {
        return this.getFeeds(sfeeds, false, force, context);
    }

    public SyndFeed getFeeds(String sfeeds, boolean ignoreInvalidFeeds, boolean force, XWikiContext context) throws IOException {
        String[] feeds = sfeeds.indexOf("\n") != -1 ? sfeeds.split("\n") : sfeeds.split("\\|");
        ArrayList entries = new ArrayList();
        SyndFeedImpl outputFeed = new SyndFeedImpl();
        if (context.getDoc() != null) {
            outputFeed.setTitle(context.getDoc().getFullName());
            outputFeed.setUri(context.getWiki().getURL(context.getDoc().getFullName(), "view", context));
            outputFeed.setAuthor(context.getDoc().getAuthor());
        } else {
            outputFeed.setTitle("XWiki Feeds");
            outputFeed.setAuthor("XWiki Team");
        }
        for (int i = 0; i < feeds.length; ++i) {
            SyndFeed feed = this.getFeed(feeds[i], ignoreInvalidFeeds, force, context);
            if (feed == null) continue;
            entries.addAll(feed.getEntries());
        }
        SyndEntryComparator comp = new SyndEntryComparator();
        Collections.sort(entries, comp);
        outputFeed.setEntries(entries);
        return outputFeed;
    }

    public SyndFeed getFeed(String sfeed, XWikiContext context) throws IOException {
        return this.getFeed(sfeed, true, false, context);
    }

    public SyndFeed getFeed(String sfeed, boolean force, XWikiContext context) throws IOException {
        return this.getFeed(sfeed, true, force, context);
    }

    public SyndFeed getFeed(String sfeed, boolean ignoreInvalidFeeds, boolean force, XWikiContext context) throws IOException {
        SyndFeed feed = null;
        this.prepareCache(context);
        if (!force) {
            feed = (SyndFeed)this.feedCache.get(sfeed);
        }
        if (feed == null) {
            feed = this.getFeedForce(sfeed, ignoreInvalidFeeds, context);
        }
        if (feed != null) {
            this.feedCache.set(sfeed, (java.lang.Object)feed);
        }
        return feed;
    }

    public SyndFeed getFeedForce(String sfeed, boolean ignoreInvalidFeeds, XWikiContext context) throws IOException {
        try {
            URL feedURL = new URL(sfeed);
            XWikiFeedFetcher feedFetcher = new XWikiFeedFetcher();
            feedFetcher.setUserAgent(context.getWiki().Param("xwiki.plugins.feed.useragent", context.getWiki().getHttpUserAgent(context)));
            SyndFeed feed = feedFetcher.retrieveFeed(feedURL, (int)context.getWiki().ParamAsLong("xwiki.plugins.feed.timeout", (long)context.getWiki().getHttpTimeout(context)));
            return feed;
        }
        catch (Exception ex) {
            if (ignoreInvalidFeeds) {
                HashMap<String, Exception> map = (HashMap<String, Exception>)context.get((java.lang.Object)"invalidFeeds");
                if (map == null) {
                    map = new HashMap<String, Exception>();
                    context.put((java.lang.Object)"invalidFeeds", map);
                }
                map.put(sfeed, ex);
                return null;
            }
            throw new IOException("Error processing " + sfeed + ": " + ex.getMessage());
        }
    }

    public int updateFeeds(XWikiContext context) throws XWikiException {
        return this.updateFeeds("XWiki.FeedList", context);
    }

    public int updateFeeds(String feedDoc, XWikiContext context) throws XWikiException {
        return this.updateFeeds(feedDoc, false, context);
    }

    public int updateFeeds(String feedDoc, boolean fullContent, XWikiContext context) throws XWikiException {
        return this.updateFeeds(feedDoc, fullContent, true, context);
    }

    public int updateFeeds(String feedDoc, boolean fullContent, boolean oneDocPerEntry, XWikiContext context) throws XWikiException {
        return this.updateFeeds(feedDoc, fullContent, oneDocPerEntry, false, context);
    }

    public int updateFeeds(String feedDoc, boolean fullContent, boolean oneDocPerEntry, boolean force, XWikiContext context) throws XWikiException {
        return this.updateFeeds(feedDoc, fullContent, oneDocPerEntry, force, "Feeds", context);
    }

    public int updateFeeds(String feedDoc, boolean fullContent, boolean oneDocPerEntry, boolean force, String space, XWikiContext context) throws XWikiException {
        this.getAggregatorURLClass(context);
        XWikiDocument doc = context.getWiki().getDocument(feedDoc, context);
        Vector objs = doc.getObjects("XWiki.AggregatorURLClass");
        if (objs == null) {
            return 0;
        }
        int total = 0;
        int nbfeeds = 0;
        int nbfeedsErrors = 0;
        for (BaseObject obj : objs) {
            if (obj == null) continue;
            String feedurl = obj.getStringValue("url");
            String feedname = obj.getStringValue("name");
            ++nbfeeds;
            int nb = this.updateFeed(feedDoc, feedname, feedurl, fullContent, oneDocPerEntry, force, space, context);
            if (nb != -1) {
                total += nb;
            } else {
                ++nbfeedsErrors;
            }
            UpdateThread updateThread = this.updateThreads.get(context.getWikiId() + ":" + space);
            if (updateThread != null) {
                updateThread.setNbLoadedFeeds(nbfeeds + updateThread.getNbLoadedFeeds());
                updateThread.setNbLoadedFeedsErrors(nbfeedsErrors + updateThread.getNbLoadedFeedsErrors());
            }
            if (context.get((java.lang.Object)"feedimgurl") != null) {
                obj.set("imgurl", context.get((java.lang.Object)"feedimgurl"), context);
                context.remove((java.lang.Object)"feedimgurl");
            }
            obj.set("nb", (java.lang.Object)nb, context);
            obj.set("date", (java.lang.Object)new Date(), context);
            context.getWiki().saveDocument(doc, context);
        }
        return total;
    }

    public int updateFeedsInSpace(String spaceReference, boolean fullContent, boolean oneDocPerEntry, boolean force, XWikiContext context) throws XWikiException {
        this.getAggregatorURLClass(context);
        String sql = ", BaseObject as obj where doc.fullName=obj.name and obj.className='XWiki.AggregatorURLClass' and doc.space='" + spaceReference + "'";
        int total = 0;
        List feedDocList = context.getWiki().getStore().searchDocumentsNames(sql, context);
        if (feedDocList != null) {
            for (int i = 0; i < feedDocList.size(); ++i) {
                String feedDocName = (String)feedDocList.get(i);
                try {
                    total += this.updateFeeds(feedDocName, fullContent, oneDocPerEntry, force, spaceReference, context);
                    continue;
                }
                catch (XWikiException e) {
                    HashMap<String, XWikiException> map = (HashMap<String, XWikiException>)context.get((java.lang.Object)"updateFeedError");
                    if (map == null) {
                        map = new HashMap<String, XWikiException>();
                        context.put((java.lang.Object)"updateFeedError", map);
                    }
                    map.put(feedDocName, e);
                    LOGGER.error("Failed to update feeds in document " + feedDocName, (Throwable)e);
                }
            }
        }
        return total;
    }

    public boolean startUpdateFeedsInSpace(String space, boolean fullContent, int scheduleTimer, XWikiContext context) throws XWikiException {
        UpdateThread updateThread = this.updateThreads.get(context.getWikiId() + ":" + space);
        if (updateThread == null) {
            updateThread = new UpdateThread(space, fullContent, scheduleTimer, this, context);
            this.updateThreads.put(context.getWikiId() + ":" + space, updateThread);
            Thread thread = new Thread((Runnable)((java.lang.Object)updateThread));
            thread.start();
            return true;
        }
        return false;
    }

    public void stopUpdateFeedsInSpace(String space, XWikiContext context) throws XWikiException {
        UpdateThread updateThread = this.updateThreads.get(context.getWikiId() + ":" + space);
        if (updateThread != null) {
            updateThread.stopUpdate();
        }
    }

    public void removeUpdateThread(String space, UpdateThread thread, XWikiContext context) {
        if (thread == this.updateThreads.get(context.getWikiId() + ":" + space)) {
            this.updateThreads.remove(context.getWikiId() + ":" + space);
        }
    }

    public UpdateThread getUpdateThread(String space, XWikiContext context) {
        return this.updateThreads.get(context.getWikiId() + ":" + space);
    }

    public Collection<String> getActiveUpdateThreads() {
        return this.updateThreads.keySet();
    }

    public int updateFeed(String feedname, String feedurl, boolean oneDocPerEntry, XWikiContext context) {
        return this.updateFeed(feedname, feedurl, false, oneDocPerEntry, context);
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry, XWikiContext context) {
        return this.updateFeed(feedname, feedurl, fullContent, oneDocPerEntry, false, context);
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry, boolean force, XWikiContext context) {
        return this.updateFeed(feedname, feedurl, fullContent, oneDocPerEntry, force, "Feeds", context);
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry, boolean force, String space, XWikiContext context) {
        return this.updateFeed("", feedname, feedurl, fullContent, oneDocPerEntry, force, space, context);
    }

    public int updateFeed(String feedDocumentName, String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry, boolean force, String space, XWikiContext context) {
        try {
            this.getFeedEntryClass(context);
            SyndFeed feed = this.getFeedForce(feedurl, true, context);
            if (feed != null) {
                if (feed.getImage() != null) {
                    context.put((java.lang.Object)"feedimgurl", (java.lang.Object)feed.getImage().getUrl());
                }
                return this.saveFeed(feedDocumentName, feedname, feedurl, feed, fullContent, oneDocPerEntry, force, space, context);
            }
            return 0;
        }
        catch (Exception e) {
            HashMap<String, Exception> map = (HashMap<String, Exception>)context.get((java.lang.Object)"updateFeedError");
            if (map == null) {
                map = new HashMap<String, Exception>();
                context.put((java.lang.Object)"updateFeedError", map);
            }
            map.put(feedurl, e);
            return -1;
        }
    }

    private int saveFeed(String feedDocumentName, String feedname, String feedurl, SyndFeed feed, boolean fullContent, boolean oneDocPerEntry, boolean force, String space, XWikiContext context) throws XWikiException {
        XWikiDocument doc = null;
        Vector objs = null;
        int nbtotal = 0;
        String prefix = space + ".Feed";
        if (!oneDocPerEntry) {
            doc = context.getWiki().getDocument(prefix + "_" + context.getWiki().clearName(feedname, true, true, context), context);
            objs = doc.getObjects("XWiki.FeedEntryClass");
            if (!StringUtils.isBlank((CharSequence)doc.getContent())) {
                this.prepareFeedEntryDocument(doc, context);
            }
        }
        List entries = feed.getEntries();
        int nb = entries.size();
        for (int i = nb - 1; i >= 0; --i) {
            SyndEntry entry = (SyndEntry)entries.get(i);
            if (oneDocPerEntry) {
                String hashCode = "" + entry.getLink().hashCode();
                String pagename = feedname + "_" + hashCode.replaceAll("-", "") + "_" + entry.getTitle();
                doc = context.getWiki().getDocument(prefix + "_" + context.getWiki().clearName(pagename, true, true, context), context);
                if (!doc.isNew() && !force) continue;
                doc.setDate(new Date());
                if (!StringUtils.isBlank((CharSequence)feedDocumentName)) {
                    doc.setParent(feedDocumentName);
                }
                if (!StringUtils.isBlank((CharSequence)context.getWiki().Param("xwiki.plugins.feed.creationDateIsPublicationDate"))) {
                    doc.setCreationDate(entry.getPublishedDate() == null ? new Date() : entry.getPublishedDate());
                }
                if (StringUtils.isBlank((CharSequence)doc.getContent())) {
                    this.prepareFeedEntryDocument(doc, context);
                }
                if (force) {
                    BaseObject obj = doc.getObject("XWiki.FeedEntryClass");
                    if (obj == null) {
                        this.saveEntry(feedname, feedurl, entry, doc, fullContent, context);
                    } else {
                        this.saveEntry(feedname, feedurl, entry, doc, obj, fullContent, context);
                    }
                } else {
                    this.saveEntry(feedname, feedurl, entry, doc, fullContent, context);
                }
                ++nbtotal;
                context.getWiki().saveDocument(doc, context);
                continue;
            }
            BaseObject obj = this.postExist(objs, entry, context);
            if (obj == null) {
                this.saveEntry(feedname, feedurl, entry, doc, fullContent, context);
                ++nbtotal;
                continue;
            }
            if (!force) continue;
            this.saveEntry(feedname, feedurl, entry, doc, obj, fullContent, context);
            ++nbtotal;
        }
        if (!oneDocPerEntry) {
            context.getWiki().saveDocument(doc, context);
        }
        return nbtotal;
    }

    private void prepareFeedEntryDocument(XWikiDocument document, XWikiContext context) {
        String syntaxId = StringUtils.isBlank((CharSequence)context.getWiki().Param("xwiki.plugins.feed.entrySyntaxId")) ? context.getWiki().getDefaultDocumentSyntax() : context.getWiki().Param("xwiki.plugins.feed.entrySyntaxId");
        String content = StringUtils.isBlank((CharSequence)context.getWiki().Param("xwiki.plugins.feed.entryContent")) ? (StringUtils.equals((CharSequence)Syntax.XWIKI_1_0.toIdString(), (CharSequence)syntaxId) ? "#includeForm(\"XWiki.FeedEntryClassSheet\")" : "{{include reference=\"XWiki.FeedEntryClassSheet\" /}}") : context.getWiki().Param("xwiki.plugins.feed.entryContent");
        String feedEntryCreator = context.getWiki().getXWikiPreference("feed_documentCreator", "xwiki.plugins.feed.documentCreator", "XWiki.superadmin", context);
        document.setCreator(feedEntryCreator);
        document.setAuthor(feedEntryCreator);
        document.setContentAuthor(feedEntryCreator);
        document.setContent(content);
        document.setSyntaxId(syntaxId);
    }

    public BaseClass getAggregatorURLClass(XWikiContext context) throws XWikiException {
        boolean needsUpdate = false;
        XWikiDocument doc = context.getWiki().getDocument("XWiki.AggregatorURLClass", context);
        BaseClass bclass = doc.getXClass();
        if (context.get((java.lang.Object)"initdone") != null) {
            return bclass;
        }
        bclass.setName("XWiki.AggregatorURLClass");
        if (!"internal".equals(bclass.getCustomMapping())) {
            needsUpdate = true;
            bclass.setCustomMapping("internal");
        }
        needsUpdate |= bclass.addTextField("name", "Name", 80);
        needsUpdate |= bclass.addTextField("url", "url", 80);
        needsUpdate |= bclass.addTextField("imgurl", "Image url", 80);
        needsUpdate |= bclass.addDateField("date", "date", "dd/MM/yyyy HH:mm:ss");
        needsUpdate |= bclass.addNumberField("nb", "nb", 5, "integer");
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthorReference(doc.getCreatorReference());
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki Aggregator URL Class");
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((java.lang.Object)doc.getSyntax())) {
            needsUpdate = true;
            doc.setContent("{{include reference=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        if (needsUpdate) {
            context.getWiki().saveDocument(doc, context);
        }
        return bclass;
    }

    public BaseClass getFeedEntryClass(XWikiContext context) throws XWikiException {
        boolean needsUpdate = false;
        XWikiDocument doc = context.getWiki().getDocument("XWiki.FeedEntryClass", context);
        BaseClass bclass = doc.getXClass();
        if (context.get((java.lang.Object)"initdone") != null) {
            return bclass;
        }
        bclass.setName("XWiki.FeedEntryClass");
        if (!"internal".equals(bclass.getCustomMapping())) {
            needsUpdate = true;
            bclass.setCustomMapping("internal");
        }
        needsUpdate |= bclass.addTextField("title", "Title", 80);
        needsUpdate |= bclass.addTextField("author", "Author", 40);
        needsUpdate |= bclass.addTextField("feedurl", "Feed URL", 80);
        needsUpdate |= bclass.addTextField("feedname", "Feed Name", 40);
        needsUpdate |= bclass.addTextField("url", "URL", 80);
        needsUpdate |= bclass.addTextField("category", "Category", 255);
        needsUpdate |= bclass.addTextAreaField("content", "Content", 80, 10);
        needsUpdate |= bclass.addTextAreaField("fullContent", "Full Content", 80, 10);
        needsUpdate |= bclass.addTextAreaField("xml", "XML", 80, 10);
        needsUpdate |= bclass.addDateField("date", "date", "dd/MM/yyyy HH:mm:ss");
        needsUpdate |= bclass.addNumberField("flag", "Flag", 5, "integer");
        needsUpdate |= bclass.addNumberField("read", "Read", 5, "integer");
        needsUpdate |= bclass.addStaticListField("tags", "Tags", 1, true, true, "", null, null);
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthorReference(doc.getCreatorReference());
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki Feed Entry Class");
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((java.lang.Object)doc.getSyntax())) {
            needsUpdate = true;
            doc.setContent("{{include reference=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        if (needsUpdate) {
            context.getWiki().saveDocument(doc, context);
        }
        return bclass;
    }

    private void saveEntry(String feedname, String feedurl, SyndEntry entry, XWikiDocument doc, boolean fullContent, XWikiContext context) throws XWikiException {
        int id = doc.createNewObject("XWiki.FeedEntryClass", context);
        BaseObject obj = doc.getObject("XWiki.FeedEntryClass", id);
        this.saveEntry(feedname, feedurl, entry, doc, obj, fullContent, context);
    }

    private void saveEntry(String feedname, String feedurl, SyndEntry entry, XWikiDocument doc, BaseObject obj, boolean fullContent, XWikiContext context) throws XWikiException {
        String title;
        obj.setStringValue("feedname", feedname);
        obj.setStringValue("title", entry.getTitle());
        try {
            title = this.stripHtmlTags(entry.getTitle());
        }
        catch (ConversionException e) {
            LOGGER.warn("Failed to strip HTML tags from entry title : " + e.getMessage());
            title = entry.getTitle();
        }
        doc.setTitle(title);
        obj.setIntValue("flag", 0);
        List categList = entry.getCategories();
        StringBuffer categs = new StringBuffer("");
        if (categList != null) {
            for (SyndCategory categ : categList) {
                if (categs.length() != 0) {
                    categs.append(", ");
                }
                categs.append(categ.getName());
            }
        }
        obj.setStringValue("category", categs.toString());
        StringBuffer contents = new StringBuffer("");
        String description = entry.getDescription() == null ? null : entry.getDescription().getValue();
        List contentList = entry.getContents();
        if (contentList != null && contentList.size() > 0) {
            for (SyndContent content : contentList) {
                if (contents.length() != 0) {
                    contents.append("\n");
                }
                contents.append(content.getValue());
            }
        }
        if (description != null && description.length() > contents.length()) {
            obj.setLargeStringValue("content", description);
        } else {
            obj.setLargeStringValue("content", contents.toString());
        }
        Date edate = entry.getPublishedDate();
        if (edate == null) {
            edate = new Date();
        }
        obj.setDateValue("date", edate);
        obj.setStringValue("url", entry.getLink());
        obj.setStringValue("author", entry.getAuthor());
        obj.setStringValue("feedurl", feedurl);
        obj.setLargeStringValue("xml", "");
        if (fullContent) {
            String url = entry.getLink();
            if (url != null && !url.trim().equals("")) {
                try {
                    String sfullContent = context.getWiki().getURLContent(url, context);
                    obj.setLargeStringValue("fullContent", sfullContent.length() > 65000 ? sfullContent.substring(0, 65000) : sfullContent);
                }
                catch (Exception e) {
                    obj.setLargeStringValue("fullContent", "Exception while reading fullContent: " + e.getMessage());
                }
            } else {
                obj.setLargeStringValue("fullContent", "No url");
            }
        }
    }

    private BaseObject postExist(Vector<BaseObject> objs, SyndEntry entry, XWikiContext context) {
        if (objs == null) {
            return null;
        }
        String title = context.getWiki().clearName(entry.getTitle(), true, true, context);
        for (BaseObject obj : objs) {
            String title2;
            if (obj == null || (title2 = (title2 = obj.getStringValue("title")) == null ? "" : context.getWiki().clearName(title2, true, true, context)).compareTo(title) != 0) continue;
            return obj;
        }
        return null;
    }

    public List<Object> search(String query, XWikiContext context) throws XWikiException {
        String[] queryTab = query.split(" ");
        if (queryTab.length > 0) {
            String sql = "select distinct obj.number, obj.name from BaseObject as obj, StringProperty as prop , LargeStringProperty as lprop where obj.className='XWiki.FeedEntryClass' and obj.id=prop.id.id and obj.id=lprop.id.id ";
            for (int i = 0; i < queryTab.length; ++i) {
                sql = sql + " and (prop.value LIKE '%" + queryTab[i] + "%' or lprop.value LIKE '%" + queryTab[i] + "%')";
            }
            List res = context.getWiki().search(sql, context);
            if (res == null) {
                return null;
            }
            ArrayList<Object> apiObjs = new ArrayList<Object>();
            for (java.lang.Object[] obj : res) {
                try {
                    XWikiDocument doc = context.getWiki().getDocument((String)obj[1], context);
                    if (!context.getWiki().getRightService().checkAccess("view", doc, context)) continue;
                    BaseObject bObj = doc.getObject("XWiki.FeedEntryClass", ((Integer)obj[0]).intValue());
                    Object apiObj = new Object(bObj, context);
                    apiObjs.add(apiObj);
                }
                catch (Exception e) {
                    HashMap<String, Exception> map = (HashMap<String, Exception>)context.get((java.lang.Object)"searchFeedError");
                    if (map == null) {
                        map = new HashMap<String, Exception>();
                        context.put((java.lang.Object)"searchFeedError", map);
                    }
                    map.put(query, e);
                }
            }
            Collections.sort(apiObjs, new EntriesComparator());
            return apiObjs;
        }
        return null;
    }

    public Object getFeedInfosbyGuid(String guid, XWikiContext context) throws XWikiException {
        return this.getFeedInfosbyGuid("XWiki.FeedList", guid, context);
    }

    public Object getFeedInfosbyGuid(String feedDoc, String guid, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(feedDoc, context);
        Vector objs = doc.getObjects("XWiki.AggregatorURLClass");
        for (BaseObject obj : objs) {
            if (guid.compareTo(obj.getStringValue("guid")) != 0) continue;
            return new Object(obj, context);
        }
        return null;
    }

    public SyndEntrySource getSyndEntrySource(String className, Map<String, java.lang.Object> params, XWikiContext context) throws XWikiException {
        try {
            Class<SyndEntrySource> sesc = Class.forName(className).asSubclass(SyndEntrySource.class);
            Constructor<SyndEntrySource> ctor = null;
            if (params != null) {
                try {
                    ctor = sesc.getConstructor(Map.class);
                    return ctor.newInstance(params);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ctor = sesc.getConstructor(new Class[0]);
            return ctor.newInstance(new java.lang.Object[0]);
        }
        catch (Throwable t) {
            throw new XWikiException(5, 0, "", t);
        }
    }

    public SyndEntry getFeedEntry(XWikiContext context) {
        return new SyndEntryImpl();
    }

    public SyndImage getFeedImage(XWikiContext context) {
        return new SyndImageImpl();
    }

    public SyndFeed getFeed(XWikiContext context) {
        return new SyndFeedImpl();
    }

    public SyndFeed getFeed(List<java.lang.Object> list, SyndEntrySource source, Map<String, java.lang.Object> sourceParams, XWikiContext context) throws XWikiException {
        SyndFeed feed = this.getFeed(context);
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (int i = 0; i < list.size(); ++i) {
            SyndEntry entry = this.getFeedEntry(context);
            try {
                source.source(entry, list.get(i), sourceParams, context);
                entries.add(entry);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        feed.setEntries(entries);
        return feed;
    }

    public SyndFeed getFeed(String query, int count, int start, SyndEntrySource source, Map<String, java.lang.Object> sourceParams, XWikiContext context) throws XWikiException {
        ArrayList<java.lang.Object> entries = new ArrayList<java.lang.Object>();
        entries.addAll(context.getWiki().getStore().searchDocumentsNames(query, count, start, context));
        return this.getFeed(entries, source, sourceParams, context);
    }

    public SyndFeed getFeed(List<java.lang.Object> list, SyndEntrySource source, Map<String, java.lang.Object> sourceParams, Map<String, java.lang.Object> metadata, XWikiContext context) throws XWikiException {
        SyndFeed feed = this.getFeed(list, source, sourceParams, context);
        this.fillFeedMetadata(feed, metadata, context);
        return feed;
    }

    public SyndFeed getFeed(String query, int count, int start, SyndEntrySource source, Map<String, java.lang.Object> sourceParams, Map<String, java.lang.Object> metadata, XWikiContext context) throws XWikiException {
        SyndFeed feed = this.getFeed(query, count, start, source, sourceParams, context);
        this.fillFeedMetadata(feed, metadata, context);
        return feed;
    }

    private void fillFeedMetadata(SyndFeed feed, Map<String, java.lang.Object> metadata, XWikiContext context) {
        XWiki xwiki = context.getWiki();
        XWikiDocument doc = context.getDoc();
        if (metadata.containsKey("author")) {
            feed.setAuthor(String.valueOf(metadata.get("author")));
        } else if (doc != null) {
            feed.setAuthor(xwiki.getUserName(doc.getAuthor(), null, false, context));
        }
        if (metadata.containsKey("description")) {
            feed.setDescription(String.valueOf(metadata.get("description")));
        }
        if (metadata.containsKey("copyright")) {
            feed.setCopyright(String.valueOf(metadata.get("copyright")));
        } else {
            feed.setCopyright(xwiki.getSpaceCopyright(context));
        }
        if (metadata.containsKey("encoding")) {
            feed.setEncoding(String.valueOf(metadata.get("encoding")));
        } else {
            feed.setEncoding(xwiki.getEncoding());
        }
        if (metadata.containsKey("url")) {
            feed.setLink(String.valueOf(metadata.get("url")));
        } else {
            feed.setLink("http://" + context.getRequest().getServerName());
        }
        if (metadata.containsKey("title")) {
            feed.setTitle(String.valueOf(metadata.get("title")));
        }
        if (metadata.containsKey("language")) {
            feed.setLanguage(String.valueOf(metadata.get("language")));
        } else if (doc != null) {
            feed.setLanguage(doc.getDefaultLanguage());
        }
    }

    public String getFeedOutput(SyndFeed feed, String type, XWikiContext context) {
        feed.setFeedType(type);
        StringWriter writer = new StringWriter();
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            output.output(feed, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getFeedOutput(List<java.lang.Object> list, SyndEntrySource source, Map<String, java.lang.Object> sourceParams, Map<String, java.lang.Object> metadata, String type, XWikiContext context) throws XWikiException {
        SyndFeed feed = this.getFeed(list, source, sourceParams, metadata, context);
        return this.getFeedOutput(feed, type, context);
    }

    public String getFeedOutput(String query, int count, int start, SyndEntrySource source, Map<String, java.lang.Object> sourceParams, Map<String, java.lang.Object> metadata, String type, XWikiContext context) throws XWikiException {
        SyndFeed feed = this.getFeed(query, count, start, source, sourceParams, metadata, context);
        return this.getFeedOutput(feed, type, context);
    }

    private String stripHtmlTags(String originalString) throws ConversionException {
        if (this.syntaxConverter == null) {
            this.syntaxConverter = (Converter)Utils.getComponent(Converter.class);
        }
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.syntaxConverter.convert((Reader)new StringReader(originalString), Syntax.HTML_4_01, Syntax.PLAIN_1_0, (WikiPrinter)printer);
        return printer.toString();
    }

    public static class EntriesComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object entry1, Object entry2) {
            BaseObject bobj1 = entry1.getXWikiObject();
            BaseObject bobj2 = entry1.getXWikiObject();
            if (bobj1.getDateValue("date") == null && bobj2.getDateValue("date") == null) {
                return 0;
            }
            if (bobj1.getDateValue("date") == null) {
                return 1;
            }
            if (bobj2.getDateValue("date") == null) {
                return -1;
            }
            return -bobj1.getDateValue("date").compareTo(bobj2.getDateValue("date"));
        }
    }

    public static class SyndEntryComparator
    implements Comparator<SyndEntry> {
        @Override
        public int compare(SyndEntry entry1, SyndEntry entry2) {
            if (entry1.getPublishedDate() == null && entry2.getPublishedDate() == null) {
                return 0;
            }
            if (entry1.getPublishedDate() == null) {
                return 1;
            }
            if (entry2.getPublishedDate() == null) {
                return -1;
            }
            return -entry1.getPublishedDate().compareTo(entry2.getPublishedDate());
        }
    }
}

