/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.feed;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.feed.FeedPlugin;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import com.xpn.xwiki.web.Utils;
import java.util.Date;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

public class UpdateThread
extends AbstractXWikiRunnable {
    protected boolean fullContent;
    protected String space;
    protected FeedPlugin feedPlugin;
    protected int scheduleTimer;
    protected boolean updateInProgress = false;
    protected boolean forceUpdate = false;
    protected boolean stopUpdate = false;
    protected Date startDate;
    protected Date endDate;
    protected int nbLoadedArticles;
    protected int nbLoadedFeeds;
    protected int nbLoadedFeedsErrors;
    protected Exception exception;
    private XWikiContext xwikiContext;

    public UpdateThread(String spaceReference, boolean fullContent, int scheduleTimer, FeedPlugin feedPlugin, XWikiContext context) {
        this.xwikiContext = context.clone();
        this.fullContent = fullContent;
        this.space = spaceReference;
        this.feedPlugin = feedPlugin;
        this.scheduleTimer = scheduleTimer;
    }

    protected void declareProperties(ExecutionContext executionContext) {
        this.xwikiContext.declareInExecutionContext(executionContext);
        this.xwikiContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (!this.stopUpdate) {
            if (!this.updateInProgress) {
                this.updateInProgress = true;
                this.nbLoadedFeeds = 0;
                this.nbLoadedFeedsErrors = 0;
                this.exception = null;
                this.nbLoadedArticles = 0;
                this.endDate = null;
                this.startDate = new Date();
                XWikiContext context = this.getXWikiContext();
                try {
                    context.getWiki().getStore().cleanUp(context);
                    this.nbLoadedArticles = this.feedPlugin.updateFeedsInSpace(this.space, this.fullContent, true, false, context);
                }
                catch (XWikiException e) {
                    this.exception = e;
                    e.printStackTrace();
                }
                finally {
                    this.updateInProgress = false;
                    this.endDate = new Date();
                    context.getWiki().getStore().cleanUp(context);
                }
                if (this.forceUpdate && !this.stopUpdate) {
                    this.forceUpdate = false;
                    this.update();
                }
            } else {
                this.forceUpdate = true;
            }
        }
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)((Execution)Utils.getComponent(Execution.class)).getContext().getProperty("xwikicontext");
    }

    public String getSpace() {
        return this.space;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getNbLoadedArticles() {
        return this.nbLoadedArticles;
    }

    public Exception getException() {
        return this.exception;
    }

    public void stopUpdate() {
        if (!this.updateInProgress) {
            this.feedPlugin.removeUpdateThread(this.space, this, this.getXWikiContext());
        }
        this.stopUpdate = true;
    }

    public int getNbLoadedFeeds() {
        return this.nbLoadedFeeds;
    }

    public void setNbLoadedFeeds(int nbLoadedFeeds) {
        this.nbLoadedFeeds = nbLoadedFeeds;
    }

    public int getNbLoadedFeedsErrors() {
        return this.nbLoadedFeedsErrors;
    }

    public void setNbLoadedFeedsErrors(int nbLoadedFeedsErrors) {
        this.nbLoadedFeedsErrors = nbLoadedFeedsErrors;
    }

    protected void runInternal() {
        while (true) {
            this.update();
            if (this.stopUpdate) {
                this.feedPlugin.removeUpdateThread(this.space, this, this.getXWikiContext());
                break;
            }
            try {
                Thread.sleep(this.scheduleTimer);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

