/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.feed;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.AbstractFeedFetcher;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class XWikiFeedFetcher
extends AbstractFeedFetcher {
    private FeedFetcherCache feedInfoCache;
    private CredentialSupplier credentialSupplier;

    public XWikiFeedFetcher() {
    }

    public XWikiFeedFetcher(FeedFetcherCache cache) {
        this();
        this.setFeedInfoCache(cache);
    }

    public XWikiFeedFetcher(FeedFetcherCache cache, CredentialSupplier credentialSupplier) {
        this(cache);
        this.setCredentialSupplier(credentialSupplier);
    }

    public synchronized FeedFetcherCache getFeedInfoCache() {
        return this.feedInfoCache;
    }

    public synchronized void setFeedInfoCache(FeedFetcherCache feedInfoCache) {
        this.feedInfoCache = feedInfoCache;
    }

    public synchronized CredentialSupplier getCredentialSupplier() {
        return this.credentialSupplier;
    }

    public synchronized void setCredentialSupplier(CredentialSupplier credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }

    public SyndFeed retrieveFeed(URL feedUrl) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        return this.retrieveFeed(feedUrl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyndFeed retrieveFeed(URL feedUrl, int timeout) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        String proxyUser;
        if (feedUrl == null) {
            throw new IllegalArgumentException("null is not a valid URL");
        }
        HttpClient client = new HttpClient();
        if (timeout != 0) {
            client.getParams().setSoTimeout(timeout);
            client.getParams().setParameter("http.connection.timeout", (Object)timeout);
        }
        System.setProperty("http.useragent", this.getUserAgent());
        client.getParams().setParameter("httpclient.useragent", (Object)this.getUserAgent());
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && !proxyHost.equals("")) {
            int port = 3128;
            if (proxyPort != null && !proxyPort.equals("")) {
                port = Integer.parseInt(proxyPort);
            }
            client.getHostConfiguration().setProxy(proxyHost, port);
        }
        if ((proxyUser = System.getProperty("http.proxyUser")) != null && !proxyUser.equals("")) {
            String proxyPassword = System.getProperty("http.proxyPassword");
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        String urlStr = feedUrl.toString();
        FeedFetcherCache cache = this.getFeedInfoCache();
        if (cache != null) {
            GetMethod method = new GetMethod(urlStr);
            method.addRequestHeader("Accept-Encoding", "gzip");
            try {
                SyndFeedInfo syndFeedInfo;
                if (this.isUsingDeltaEncoding()) {
                    method.setRequestHeader("A-IM", "feed");
                }
                if ((syndFeedInfo = cache.getFeedInfo(feedUrl)) != null) {
                    method.setRequestHeader("If-None-Match", syndFeedInfo.getETag());
                    if (syndFeedInfo.getLastModified() instanceof String) {
                        method.setRequestHeader("If-Modified-Since", (String)syndFeedInfo.getLastModified());
                    }
                }
                method.setFollowRedirects(true);
                int statusCode = client.executeMethod((HttpMethod)method);
                this.fireEvent("FEED_POLLED", urlStr);
                this.handleErrorCodes(statusCode);
                SyndFeed feed = this.getFeed(syndFeedInfo, urlStr, (HttpMethod)method, statusCode);
                syndFeedInfo = this.buildSyndFeedInfo(feedUrl, urlStr, (HttpMethod)method, feed, statusCode);
                cache.setFeedInfo(new URL(urlStr), syndFeedInfo);
                SyndFeed syndFeed = feed = syndFeedInfo.getSyndFeed();
                return syndFeed;
            }
            finally {
                method.releaseConnection();
            }
        }
        GetMethod method = new GetMethod(urlStr);
        try {
            method.setFollowRedirects(true);
            int statusCode = client.executeMethod((HttpMethod)method);
            this.fireEvent("FEED_POLLED", urlStr);
            this.handleErrorCodes(statusCode);
            SyndFeed syndFeed = this.getFeed(null, urlStr, (HttpMethod)method, statusCode);
            return syndFeed;
        }
        finally {
            method.releaseConnection();
        }
    }

    private SyndFeedInfo buildSyndFeedInfo(URL feedUrl, String urlStr, HttpMethod method, SyndFeed feed, int statusCode) throws MalformedURLException {
        Header eTagHeader;
        Header lastModifiedHeader;
        SyndFeedInfo cachedInfo;
        FeedFetcherCache cache;
        SyndFeedInfo syndFeedInfo = new SyndFeedInfo();
        syndFeedInfo.setUrl(new URL(urlStr));
        syndFeedInfo.setId(feedUrl.toString());
        Header imHeader = method.getResponseHeader("IM");
        if (imHeader != null && imHeader.getValue().indexOf("feed") >= 0 && this.isUsingDeltaEncoding() && (cache = this.getFeedInfoCache()) != null && statusCode == 226 && (cachedInfo = cache.getFeedInfo(feedUrl)) != null) {
            SyndFeed cachedFeed = cachedInfo.getSyndFeed();
            feed = XWikiFeedFetcher.combineFeeds((SyndFeed)cachedFeed, (SyndFeed)feed);
        }
        if ((lastModifiedHeader = method.getResponseHeader("Last-Modified")) != null) {
            syndFeedInfo.setLastModified((Object)lastModifiedHeader.getValue());
        }
        if ((eTagHeader = method.getResponseHeader("ETag")) != null) {
            syndFeedInfo.setETag(eTagHeader.getValue());
        }
        syndFeedInfo.setSyndFeed(feed);
        return syndFeedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyndFeed retrieveFeed(String urlStr, HttpMethod method) throws IOException, FeedException {
        InputStream stream = null;
        stream = method.getResponseHeader("Content-Encoding") != null && "gzip".equalsIgnoreCase(method.getResponseHeader("Content-Encoding").getValue()) ? new GZIPInputStream(method.getResponseBodyAsStream()) : method.getResponseBodyAsStream();
        try {
            XmlReader reader = null;
            reader = method.getResponseHeader("Content-Type") != null ? new XmlReader(stream, method.getResponseHeader("Content-Type").getValue(), true) : new XmlReader(stream, true);
            SyndFeed syndFeed = new SyndFeedInput().build((Reader)reader);
            return syndFeed;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private SyndFeed getFeed(SyndFeedInfo syndFeedInfo, String urlStr, HttpMethod method, int statusCode) throws IOException, FeedException {
        if (statusCode == 304 && syndFeedInfo != null) {
            this.fireEvent("FEED_UNCHANGED", urlStr);
            return syndFeedInfo.getSyndFeed();
        }
        SyndFeed feed = XWikiFeedFetcher.retrieveFeed(urlStr, method);
        this.fireEvent("FEED_RETRIEVED", urlStr, feed);
        return feed;
    }

    public static interface CredentialSupplier {
        public Credentials getCredentials(String var1, String var2);
    }
}

