/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.io.StringWriter;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.xwiki.icon.Icon;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.internal.VelocityRenderer;
import org.xwiki.skinx.SkinExtension;

public class DefaultIconRenderer
implements IconRenderer {
    @Inject
    @Named(value="ssx")
    private SkinExtension skinExtension;
    @Inject
    @Named(value="linkx")
    private SkinExtension linkExtension;
    @Inject
    @Named(value="jsx")
    private SkinExtension jsExtension;
    @Inject
    private VelocityRenderer velocityRenderer;

    public String render(String iconName, IconSet iconSet) throws IconException {
        return this.render(iconSet, iconName, iconSet.getRenderWiki());
    }

    public String renderHTML(String iconName, IconSet iconSet) throws IconException {
        return this.render(iconSet, iconName, iconSet.getRenderHTML());
    }

    private String render(IconSet iconSet, String iconName, String renderer) throws IconException {
        if (!StringUtils.isBlank((String)iconSet.getCss())) {
            this.activeCSS(iconSet);
        }
        if (!StringUtils.isBlank((String)iconSet.getSsx())) {
            this.activeSSX(iconSet);
        }
        if (!StringUtils.isBlank((String)iconSet.getJsx())) {
            this.activeJSX(iconSet);
        }
        return this.renderIcon(iconSet, iconName, renderer);
    }

    private void activeCSS(IconSet iconSet) throws IconException {
        String url = this.velocityRenderer.render(iconSet.getCss());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("rel", "stylesheet");
        this.linkExtension.use(url, parameters);
    }

    private void activeSSX(IconSet iconSet) {
        this.skinExtension.use(iconSet.getSsx());
    }

    private void activeJSX(IconSet iconSet) {
        this.jsExtension.use(iconSet.getJsx());
    }

    private String renderIcon(IconSet iconSet, String iconName, String renderer) throws IconException {
        Icon icon = iconSet.getIcon(iconName);
        if (icon == null) {
            return "";
        }
        StringWriter contentToParse = new StringWriter();
        contentToParse.write("#set($icon = \"");
        contentToParse.write(icon.getValue());
        contentToParse.write("\")\n");
        contentToParse.write(renderer);
        return this.velocityRenderer.render(contentToParse.toString());
    }
}

