/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="icon")
@Singleton
public class IconManagerScriptService
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.icon.error";
    @Inject
    private IconManager iconManager;
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private Execution execution;

    public String render(String iconName) {
        try {
            return this.iconManager.render(iconName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String render(String iconName, String iconSetName) {
        try {
            return this.iconManager.render(iconName, iconSetName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String render(String iconName, String iconSetName, boolean fallback) {
        try {
            return this.iconManager.render(iconName, iconSetName, fallback);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String renderHTML(String iconName) {
        try {
            return this.iconManager.renderHTML(iconName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String renderHTML(String iconName, String iconSetName) {
        try {
            return this.iconManager.renderHTML(iconName, iconSetName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String renderHTML(String iconName, String iconSetName, boolean fallback) {
        try {
            return this.iconManager.renderHTML(iconName, iconSetName, fallback);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public List<String> getIconSetNames() {
        try {
            return this.iconSetManager.getIconSetNames();
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public List<String> getIconNames() {
        try {
            return this.iconManager.getIconNames();
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public List<String> getIconNames(String iconSetName) {
        try {
            return this.iconManager.getIconNames(iconSetName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String getCurrentIconSetName() {
        try {
            IconSet currentIconSet = this.iconSetManager.getCurrentIconSet();
            if (currentIconSet != null) {
                return currentIconSet.getName();
            }
        }
        catch (IconException e) {
            this.setLastError(e);
        }
        return null;
    }

    public IconException getLastError() {
        return (IconException)((Object)this.execution.getContext().getProperty(ERROR_KEY));
    }

    private void setLastError(IconException e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }
}

