/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.image;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.image.ImagePluginAPI;
import com.xpn.xwiki.plugin.image.ImageProcessor;
import com.xpn.xwiki.web.Utils;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;

@Deprecated
public class ImagePlugin
extends XWikiDefaultPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ImagePlugin.class);
    private static final String PLUGIN_NAME = "image";
    private Cache<XWikiAttachment> imageCache;
    private int capacity = 50;
    private float defaultQuality = 0.5f;
    private ImageProcessor imageProcessor;

    public ImagePlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.init(context);
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new ImagePluginAPI((ImagePlugin)plugin, context);
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public void init(XWikiContext context) {
        super.init(context);
        this.initCache(context);
        String imageProcessorHint = context.getWiki().Param("xwiki.plugin.image.processorHint", "thumbnailator");
        this.imageProcessor = (ImageProcessor)Utils.getComponent(ImageProcessor.class, (String)imageProcessorHint);
        String defaultQualityParam = context.getWiki().Param("xwiki.plugin.image.defaultQuality");
        if (!StringUtils.isBlank((CharSequence)defaultQualityParam)) {
            try {
                this.defaultQuality = Math.max(0.0f, Math.min(1.0f, Float.parseFloat(defaultQualityParam.trim())));
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse xwiki.plugin.image.defaultQuality configuration parameter. Using {} as the default image quality.", (Object)Float.valueOf(this.defaultQuality));
            }
        }
    }

    private void initCache(XWikiContext context) {
        if (this.imageCache == null) {
            CacheConfiguration configuration = new CacheConfiguration();
            configuration.setConfigurationId("xwiki.plugin.image");
            LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
            configuration.put((Object)"eviction", (Object)lru);
            String capacityParam = context.getWiki().Param("xwiki.plugin.image.cache.capacity");
            if (!StringUtils.isBlank((CharSequence)capacityParam) && StringUtils.isNumeric((CharSequence)capacityParam.trim())) {
                try {
                    this.capacity = Integer.parseInt(capacityParam.trim());
                }
                catch (NumberFormatException e) {
                    LOG.warn(String.format("Failed to parse xwiki.plugin.image.cache.capacity configuration parameter. Using %s as the cache capacity.", this.capacity), (Throwable)e);
                }
            }
            lru.setMaxEntries(this.capacity);
            try {
                this.imageCache = ((CacheManager)Utils.getComponent(CacheManager.class)).createNewLocalCache(configuration);
            }
            catch (CacheException e) {
                LOG.error("Error initializing the image cache.", (Throwable)e);
            }
        }
    }

    public void flushCache() {
        if (this.imageCache != null) {
            this.imageCache.dispose();
        }
        this.imageCache = null;
    }

    public XWikiAttachment downloadAttachment(XWikiAttachment attachment, XWikiContext context) {
        if (!this.imageProcessor.isMimeTypeSupported(attachment.getMimeType(context))) {
            return attachment;
        }
        int height = -1;
        try {
            height = Integer.parseInt(context.getRequest().getParameter("height"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int width = -1;
        try {
            width = Integer.parseInt(context.getRequest().getParameter("width"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float quality = -1.0f;
        try {
            quality = Float.parseFloat(context.getRequest().getParameter("quality"));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (height <= 0 && width <= 0 && quality < 0.0f) {
            return attachment;
        }
        try {
            return this.downloadImage(attachment, width, height, quality, context);
        }
        catch (Exception e) {
            LOG.warn("Failed to transform image attachment.", (Throwable)e);
            return attachment;
        }
    }

    private XWikiAttachment downloadImage(XWikiAttachment image, int width, int height, float quality, XWikiContext context) throws Exception {
        this.initCache(context);
        boolean keepAspectRatio = Boolean.valueOf(context.getRequest().getParameter("keepAspectRatio"));
        XWikiAttachment thumbnail = this.imageCache == null ? this.shrinkImage(image, width, height, keepAspectRatio, quality, context) : this.downloadImageFromCache(image, width, height, keepAspectRatio, quality, context);
        String fileName = thumbnail.getFilename();
        String extension = StringUtils.lowerCase((String)StringUtils.substringAfterLast((String)fileName, (String)String.valueOf('.')));
        if (thumbnail != image && !Arrays.asList("jpeg", "jpg", "png").contains(extension)) {
            thumbnail.setFilename(StringUtils.substringBeforeLast((String)fileName, (String)".") + ".png");
        }
        return thumbnail;
    }

    private XWikiAttachment downloadImageFromCache(XWikiAttachment image, int width, int height, boolean keepAspectRatio, float quality, XWikiContext context) throws Exception {
        String key = String.format("%s;%s;%s;%s;%s;%s;%s", image.getId(), image.getVersion(), image.getDate().getTime(), width, height, keepAspectRatio, Float.valueOf(quality));
        XWikiAttachment thumbnail = (XWikiAttachment)this.imageCache.get(key);
        if (thumbnail == null) {
            thumbnail = this.shrinkImage(image, width, height, keepAspectRatio, quality, context);
            this.imageCache.set(key, (Object)thumbnail);
        }
        return thumbnail;
    }

    private XWikiAttachment shrinkImage(XWikiAttachment attachment, int requestedWidth, int requestedHeight, boolean keepAspectRatio, float requestedQuality, XWikiContext context) throws Exception {
        Image image = this.imageProcessor.readImage(attachment.getContentInputStream(context));
        int currentWidth = image.getWidth(null);
        int currentHeight = image.getHeight(null);
        int[] dimensions = this.reduceImageDimensions(currentWidth, currentHeight, requestedWidth, requestedHeight, keepAspectRatio);
        float quality = requestedQuality;
        if (quality < 0.0f) {
            if (dimensions[0] == currentWidth && dimensions[1] == currentHeight) {
                return attachment;
            }
            quality = this.defaultQuality;
        }
        RenderedImage shrunkImage = this.imageProcessor.scaleImage(image, dimensions[0], dimensions[1]);
        XWikiAttachment thumbnail = attachment.clone();
        thumbnail.loadAttachmentContent(context);
        OutputStream acos = thumbnail.getAttachment_content().getContentOutputStream();
        this.imageProcessor.writeImage(shrunkImage, attachment.getMimeType(context), quality, acos);
        IOUtils.closeQuietly((OutputStream)acos);
        return thumbnail;
    }

    private int[] reduceImageDimensions(int currentWidth, int currentHeight, int requestedWidth, int requestedHeight, boolean keepAspectRatio) {
        double aspectRatio = (double)currentWidth / (double)currentHeight;
        int width = currentWidth;
        int height = currentHeight;
        if (requestedWidth <= 0 || requestedWidth >= currentWidth) {
            if (requestedHeight > 0 && requestedHeight < currentHeight) {
                width = (int)((double)requestedHeight * aspectRatio);
                height = requestedHeight;
            }
        } else if (requestedHeight <= 0 || requestedHeight >= currentHeight) {
            width = requestedWidth;
            height = (int)((double)requestedWidth / aspectRatio);
        } else if (keepAspectRatio) {
            width = requestedWidth;
            height = (int)((double)requestedWidth / aspectRatio);
            if (height > requestedHeight) {
                width = (int)((double)requestedHeight * aspectRatio);
                height = requestedHeight;
            }
        } else {
            width = requestedWidth;
            height = requestedHeight;
        }
        return new int[]{width, height};
    }

    public int getWidth(XWikiAttachment attachment, XWikiContext context) throws IOException, XWikiException {
        return this.imageProcessor.readImage(attachment.getContentInputStream(context)).getWidth(null);
    }

    public int getHeight(XWikiAttachment attachment, XWikiContext context) throws IOException, XWikiException {
        return this.imageProcessor.readImage(attachment.getContentInputStream(context)).getHeight(null);
    }
}

