/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages.query;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="documentReferenceResolver/nestedPages")
@Singleton
public class DocumentReferenceResolverFilter
implements QueryFilter {
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    @Named(value="current")
    protected SpaceReferenceResolver<String> currentSpaceReferenceResolver;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;

    public List<?> filterResults(List results) {
        String defaultDocumentName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
        for (Object result : results) {
            String reference = (String)((Object[])result)[0];
            boolean terminal = this.toBoolean(((Object[])result)[1]);
            if (terminal) {
                documentReferences.add(this.currentDocumentReferenceResolver.resolve((Object)reference, new Object[0]));
                continue;
            }
            SpaceReference spaceReference = this.currentSpaceReferenceResolver.resolve((Object)reference, new Object[0]);
            documentReferences.add(new DocumentReference(defaultDocumentName, spaceReference));
        }
        return documentReferences;
    }

    public String filterStatement(String statement, String language) {
        return statement;
    }

    protected boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return false;
    }
}

