/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;

/**
 * The translations tree node.
 * 
 * @version $Id: 6a0bcb3e7c8480188ff779449d360b197643ffd8 $
 * @since 8.3M2
 * @since 7.4.5
 */
@Component
@Named("translations")
@InstantiationStrategy(ComponentInstantiationStrategy.PER_LOOKUP)
public class TranslationsTreeNode extends AbstractDocumentTreeNode
{
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    /**
     * Default constructor.
     */
    public TranslationsTreeNode()
    {
        super("translations");
    }

    @Override
    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception
    {
        XWikiContext xcontext = this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        String serializedDocRef = this.defaultEntityReferenceSerializer.serialize(documentReference);
        List<Locale> locales = document.getTranslationLocales(xcontext);
        List<String> children = new ArrayList<String>();
        for (Locale locale : subList(locales, offset, limit)) {
            children.add("translation:" + serializedDocRef + '/' + locale);
        }
        return children;
    }

    @Override
    protected int getChildCount(DocumentReference documentReference) throws Exception
    {
        XWikiContext xcontext = this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        return document.getTranslationLocales(xcontext).size();
    }
}
