/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.index.tree.internal.nestedspaces;

import java.util.Collections;
import java.util.List;

import javax.inject.Named;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

/**
 * The document node in the nested spaces hierarchy.
 * 
 * @version $Id: 976159e0b06ea14984210d38c8bcbf28ec2585d3 $
 * @since 8.3M2
 * @since 7.4.5
 */
@Component
@Named("document/nestedSpaces")
@InstantiationStrategy(ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTreeNode extends org.xwiki.index.tree.internal.nestedpages.DocumentTreeNode
{
    @Override
    protected List<DocumentReference> getChildDocuments(DocumentReference documentReference, int offset, int limit)
    {
        return Collections.emptyList();
    }

    @Override
    protected int getChildDocumentsCount(DocumentReference documentReference)
    {
        return 0;
    }

    @Override
    protected EntityReference getParent(DocumentReference documentReference)
    {
        return documentReference.getParent();
    }
}
